/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.OperationTargetTypeEnum;
import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfOperationSalesProductMDao;
import com.artfess.cqlt.manager.QfOperationSalesProductDManager;
import com.artfess.cqlt.manager.QfOperationSalesProductMManager;
import com.artfess.cqlt.model.QfOperationSalesProductD;
import com.artfess.cqlt.model.QfOperationSalesProductM;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfOperationSalesProductMManagerImpl
extends BaseManagerImpl<QfOperationSalesProductMDao, QfOperationSalesProductM>
implements QfOperationSalesProductMManager {
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();
    @Autowired
    private QfOperationSalesProductDManager operationSalesDManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationSalesProductM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfOperationSalesProductMS = ((QfOperationSalesProductMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationSalesProductMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSalesProductMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationSalesProductM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfOperationSalesProductMS = ((QfOperationSalesProductMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfOperationSalesProductMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationSalesProductMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(QfOperationSalesProductM t) {
        QfOperationSalesProductM QfOperationSalesProductM2 = (QfOperationSalesProductM)((Object)((QfOperationSalesProductMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfOperationSalesProductM2) {
            return false;
        }
        QfOperationSalesProductM2.setStatus(QfOperationSalesProductM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationSalesProductMDao)this.baseMapper).updateById((Object)QfOperationSalesProductM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationSalesProductD> list, String mainId) {
        QfOperationSalesProductM QfOperationSalesProductM2 = (QfOperationSalesProductM)((Object)((QfOperationSalesProductMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)QfOperationSalesProductM2), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(QfOperationSalesProductM2.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationSalesDManager.remove((Wrapper)queryWrapper);
        Map<String, QfOperationSalesProductD> historyMap = this.historyList(QfOperationSalesProductM2);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(QfOperationSalesProductM2.getFillDate());
            if (null == detail.getBudgetYtd()) {
                detail.setBudgetYtd(BigDecimal.ZERO);
            }
            if (null == detail.getActualYtd()) {
                detail.setActualYtd(BigDecimal.ZERO);
            }
            if (!historyMap.containsKey(detail.getProduct())) {
                detail.setActual(detail.getActualYtd());
                detail.setBudget(detail.getActualYtd());
            } else {
                QfOperationSalesProductD salesProductD = (QfOperationSalesProductD)((Object)((Object)historyMap.get(detail.getProduct())));
                if (null == salesProductD.getBudgetYtd()) {
                    detail.setBudget(BigDecimal.ZERO);
                } else {
                    detail.setBudget(detail.getBudgetYtd().subtract(salesProductD.getBudgetYtd()));
                }
                if (null == salesProductD.getActualYtd()) {
                    detail.setActual(BigDecimal.ZERO);
                } else {
                    detail.setActual(detail.getActualYtd().subtract(salesProductD.getActualYtd()));
                }
                if (null == salesProductD) {
                    detail.setActual(detail.getActualYtd());
                    detail.setBudget(detail.getActualYtd());
                }
            }
            String dataType = ProductSalesDataTypeEnum.getType((String)detail.getDataType());
            detail.setDataType(dataType);
        });
        boolean b = this.operationSalesDManager.saveBatch(list);
        return b;
    }

    @Override
    public List<OpTargetRespVo> dataAnalysis(OpReportReqVo t, SysSubjectTarget target) {
        List<String> typeList = Arrays.asList(target.getType().split(","));
        ArrayList newTypeList = Lists.newArrayList();
        for (int i = 0; i < typeList.size(); ++i) {
            if (i <= 0) continue;
            newTypeList.add(typeList.get(i));
        }
        ArrayList resultList = Lists.newArrayList();
        newTypeList.forEach(type -> {
            OperationTargetTypeEnum targetTypeEnum = OperationTargetTypeEnum.getTarget((String)type);
            if (null == targetTypeEnum) {
                return;
            }
            OpDateReqVo dateReqVo = this.financialTimeUtils.processOpDateReqVo(t, (String)type);
            this.financialTimeUtils.processOpDateQuery(t, dateReqVo);
            switch (targetTypeEnum) {
                case ndsj: {
                    this.yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndkhsy: {
                    this.yearCustomerAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndkh: {
                    this.yearCustomerProportion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndcpsy: {
                    this.yearProductAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndcp: {
                    this.yearProductProportion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case dysj: {
                    this.monthAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
            }
        });
        return resultList;
    }

    private void monthAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).monthAnalysis(t);
        opReportRespVos.forEach(resp -> resp.setYear(t.getYear()));
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearProductProportion(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).yearProductDetail(t);
        BigDecimal totalActual = opReportRespVos.stream().map(OpReportRespVo::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
        opReportRespVos.stream().forEach(resp -> {
            BigDecimal actual = BigDecimal.ZERO;
            if (null != resp.getActual() && 0.0 != resp.getActual().doubleValue()) {
                actual = resp.getActual().divide(totalActual, 4, 4).multiply(new BigDecimal(100));
            }
            resp.setProduct(ProductSalesDataTypeEnum.getDesc((String)resp.getProduct()));
            resp.setActual(actual);
            resp.setBudget(null);
        });
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearProductAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        if (StringUtil.isEmpty((String)t.getProduct())) {
            t.setProduct(ProductSalesDataTypeEnum.ONE.getType());
        }
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).yearProductData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearCustomerProportion(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).yearCustomerData(t);
        BigDecimal totalActual = opReportRespVos.stream().map(OpReportRespVo::getActual).reduce(BigDecimal.ZERO, BigDecimal::add);
        opReportRespVos.stream().forEach(resp -> {
            BigDecimal actual = BigDecimal.ZERO;
            if (null != resp.getActual() && 0.0 != resp.getActual().doubleValue()) {
                actual = resp.getActual().divide(totalActual, 4, 4).multiply(new BigDecimal(100));
            }
            resp.setActual(actual);
            resp.setBudget(null);
        });
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearCustomerAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private OpTargetRespVo getOpTargetRespVo(SysSubjectTarget target, OperationTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        OpTargetRespVo resultFa = new OpTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setType(type);
        resultFa.setSn(targetTypeEnum.getType());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        return resultFa;
    }

    private void yearAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = this.getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = ((QfOperationSalesProductMDao)this.baseMapper).yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private Map<String, QfOperationSalesProductD> historyList(QfOperationSalesProductM QfFinancePlBudgetM2) {
        List<QfOperationSalesProductD> historyList = ((QfOperationSalesProductMDao)this.baseMapper).historyList(QfFinancePlBudgetM2.getFillMonth() - 1, QfFinancePlBudgetM2.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        Map<String, QfOperationSalesProductD> historyProduct = historyList.stream().collect(Collectors.toMap(item -> item.getProduct(), item -> item));
        return historyProduct;
    }
}

