/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.ReportTypeEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.dao.QfHrPersonMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinancePlDManager;
import com.artfess.cqlt.manager.QfFinancePlSManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.manager.QfHrPersonMManager;
import com.artfess.cqlt.manager.QfReportLogManager;
import com.artfess.cqlt.manager.QfRzStatisticalManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinancePlD;
import com.artfess.cqlt.model.QfFinancePlS;
import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.ReportVo;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.HeaderNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Sets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfHrPersonMManagerImpl
extends BaseManagerImpl<QfHrPersonMDao, QfHrPersonM>
implements QfHrPersonMManager {
    private static final Logger log = LoggerFactory.getLogger(QfHrPersonMManagerImpl.class);
    private static final String HR030000s = "HR030000s";
    private static final String PL3300S = "PL3300S";
    @Autowired
    private QfHrPersonDManager personDManager;
    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;
    @Autowired
    private QfReportLogManager reportLogManager;
    @Resource(name="bmpExecutorService")
    private ExecutorService executorService;
    @Autowired
    private QfRzStatisticalManager rzStatisticalManager;
    @Autowired
    private QfFinancialStatisticalManager financialStatisticalManager;
    @Autowired
    private QfFinancePlDManager plDManager;
    @Autowired
    private QfFinancePlSManager plSManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<HeaderNode> list, String mainId) {
        QfHrPersonM mainInfo = (QfHrPersonM)((Object)((QfHrPersonMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)mainInfo), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(mainInfo.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.personDManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        Map<String, QfSubjectInternationalInfo> subjectMap = this.subjectInternationalInfoManager.getSubjectCodeMap("HR");
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        Map<String, List<QfHrPersonD>> historyMap = this.historyList(mainInfo);
        HashSet noexitSubjectCodes = Sets.newHashSet();
        List<HeaderNode> headerNodeList = list.stream().collect(Collectors.groupingBy(HeaderNode::getRow)).get(0);
        HashMap headerMap = Maps.newHashMap();
        for (HeaderNode headerNode : headerNodeList) {
            headerMap.put(headerNode.getColumn(), headerNode.getHeaderName());
        }
        Map<Integer, List<HeaderNode>> detailMap = list.stream().collect(Collectors.groupingBy(HeaderNode::getColumn));
        List<HeaderNode> subjectCodes = detailMap.get(1);
        HashMap subjectCodeMap = Maps.newHashMap();
        for (HeaderNode headerNode : subjectCodes) {
            subjectCodeMap.put(headerNode.getRow(), headerNode.getHeaderName());
        }
        ArrayList detailList = Lists.newArrayList();
        for (Map.Entry<Integer, List<HeaderNode>> entry : detailMap.entrySet()) {
            Integer column = entry.getKey();
            List<HeaderNode> nodes = entry.getValue();
            String enterpriseCode = (String)headerMap.get(column);
            if ("All".equals(headerMap.get(column))) {
                enterpriseCode = "CIGR";
            }
            List<Object> historyDetailList = Lists.newArrayList();
            if (historyMap.containsKey(enterpriseCode)) {
                historyDetailList = historyMap.get(enterpriseCode);
            }
            for (HeaderNode node : nodes) {
                QfHrPersonD qfHrPersonD = new QfHrPersonD();
                if (0 == node.getRow() || node.getColumn() <= 1 || StringUtils.isEmpty((Object)node.getHeaderName())) continue;
                qfHrPersonD.setMainId(mainId);
                qfHrPersonD.setActual(new BigDecimal(node.getHeaderName()));
                qfHrPersonD.setActualYtd(qfHrPersonD.getActual());
                qfHrPersonD.setFillDate(mainInfo.getFillDate());
                qfHrPersonD.setEnterpriseCode(enterpriseCode);
                qfHrPersonD.setSubjectCode((String)subjectCodeMap.get(node.getRow()));
                qfHrPersonD.setSn(node.getRow());
                qfHrPersonD.setColumn(node.getColumn());
                if (!subjectMap.containsKey(qfHrPersonD.getSubjectCode())) {
                    noexitSubjectCodes.add(qfHrPersonD.getSubjectCode());
                } else {
                    Map<String, QfHrPersonD> historyDetailMap;
                    QfSubjectInternationalInfo subjectInternationalInfo = subjectMap.get(qfHrPersonD.getSubjectCode());
                    qfHrPersonD.setSubjectNameEn(subjectInternationalInfo.getNameEn());
                    qfHrPersonD.setSubjectUnit(subjectInternationalInfo.getUnit());
                    qfHrPersonD.setSubjectName(subjectInternationalInfo.getName());
                    if (!StringUtils.isEmpty((Object)subjectInternationalInfo.getLevel())) {
                        qfHrPersonD.setSubjectLevel(Integer.parseInt(subjectInternationalInfo.getLevel()));
                    }
                    if ((historyDetailMap = historyDetailList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item))).containsKey(qfHrPersonD.getSubjectCode()) && subjectInternationalInfo.getType().equals(SubjectTypeEnum.RZJE.getType())) {
                        QfHrPersonD historyDetail = historyDetailMap.get(qfHrPersonD.getSubjectCode());
                        qfHrPersonD.setActualYtd(qfHrPersonD.getActual().add(historyDetail.getActualYtd()));
                    }
                }
                if (enterpriseInfoMap.containsKey(qfHrPersonD.getEnterpriseCode())) {
                    QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(qfHrPersonD.getEnterpriseCode());
                    qfHrPersonD.setEnterpriseName(qfEnterpriseInfo.getName());
                    qfHrPersonD.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
                }
                detailList.add(qfHrPersonD);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)noexitSubjectCodes)) {
            throw new BaseException(((Object)noexitSubjectCodes).toString() + I18nUtil.getMessage((String)"code.notExist", (Locale)LocaleContextHolder.getLocale()));
        }
        try {
            this.partitionSave(detailList);
        }
        catch (Exception exception) {
            log.error("\u5bfc\u5165\u4f8b\u5982\u62a5\u8868\u6570\u636e\u5931\u8d25:{}", (Object)exception.getMessage());
            exception.printStackTrace();
            return false;
        }
        this.asyncReportInfo(mainInfo, detailList);
        return true;
    }

    private void asyncReportInfo(QfHrPersonM mainInfo, List<QfHrPersonD> list) {
        this.executorService.execute(() -> {
            String msg = null;
            String reportStatus = "0";
            try {
                this.saveHrVo(mainInfo, list);
                reportStatus = "1";
            }
            catch (Exception e) {
                msg = e.getMessage();
                log.error("\u4eba\u8d44\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            }
            this.reportLogManager.saveReportInfo(reportStatus, msg, ReportTypeEnum.HR_ACTUAL.getType(), mainInfo.getFillYear(), mainInfo.getFillMonth());
        });
    }

    private Map<String, List<QfHrPersonD>> historyList(QfHrPersonM mainInfo) {
        List<QfHrPersonD> historyList = ((QfHrPersonMDao)this.baseMapper).historyList(mainInfo.getFillMonth() - 1, mainInfo.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        return historyList.stream().collect(Collectors.groupingBy(QfHrPersonD::getEnterpriseCode));
    }

    private void saveHrVo(QfHrPersonM mainInfo, List<QfHrPersonD> detailList) {
        ArrayList financialVoList = Lists.newArrayList();
        DataInfoVo dataInfoVo = new DataInfoVo();
        dataInfoVo.setYear(mainInfo.getFillYear());
        dataInfoVo.setMonth(mainInfo.getFillMonth());
        dataInfoVo.setQuarter(mainInfo.getFillQuarter());
        ArrayList hrList = Lists.newArrayList();
        detailList.forEach(detail -> {
            ReportVo hrVo = new ReportVo();
            hrVo.setEnterpriseCode(detail.getEnterpriseCode());
            hrVo.setActual(detail.getActual());
            hrVo.setActualYtd(detail.getActualYtd());
            hrVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(hrVo);
            if (HR030000s.equals(hrVo.getSubjectCode())) {
                hrList.add(hrVo);
            }
        });
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)mainInfo.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)mainInfo.getFillMonth());
        queryWrapper.eq((Object)"subject_code_", (Object)PL3300S);
        List<QfFinancePlD> plDList = this.plDManager.getQfDetailList(mainInfo, PL3300S);
        plDList.forEach(detail -> {
            ReportVo hrVo = new ReportVo();
            hrVo.setEnterpriseCode(detail.getEnterpriseCode());
            hrVo.setActual(detail.getActual());
            hrVo.setActualYtd(detail.getActualYtd());
            hrVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(hrVo);
        });
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"fill_year_", (Object)mainInfo.getFillYear());
        query.eq((Object)"fill_month_", (Object)mainInfo.getFillMonth());
        query.eq((Object)"subject_code_", (Object)PL3300S);
        List totalList = this.plSManager.list((Wrapper)query);
        query = new QueryWrapper();
        query.eq((Object)"fill_year_", (Object)mainInfo.getFillYear());
        query.eq((Object)"fill_month_", (Object)(mainInfo.getFillMonth() - 1));
        query.eq((Object)"subject_code_", (Object)PL3300S);
        List historyList = this.plSManager.list((Wrapper)query);
        Map<String, QfFinancePlS> historyMap = historyList.stream().collect(Collectors.toMap(item -> item.getSubjectCode(), item -> item));
        totalList.forEach(detail -> {
            ReportVo financialVo = new ReportVo();
            financialVo.setEnterpriseCode(group.getCode());
            financialVo.setActualYtd(detail.getActualConsolidated());
            if (historyMap.containsKey(detail.getSubjectCode())) {
                QfFinancePlS plS = (QfFinancePlS)((Object)((Object)historyMap.get(detail.getSubjectCode())));
                if (null == financialVo.getActualYtd()) {
                    financialVo.setActualYtd(BigDecimal.ZERO);
                }
                if (null == plS || null == plS.getActualConsolidated()) {
                    financialVo.setActual(financialVo.getActualYtd());
                } else {
                    financialVo.setActual(financialVo.getActualYtd().subtract(((QfFinancePlS)((Object)((Object)historyMap.get(detail.getSubjectCode())))).getActualConsolidated()));
                }
            } else {
                financialVo.setActual(financialVo.getActualYtd());
            }
            financialVo.setSubjectCode(detail.getSubjectCode());
            financialVoList.add(financialVo);
        });
        this.rzStatisticalManager.saveData(financialVoList, dataInfoVo);
        dataInfoVo.setFlag(true);
        this.financialStatisticalManager.saveData(hrList, dataInfoVo, 1);
    }

    private void partitionSave(List<QfHrPersonD> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.personDManager.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    @Override
    public boolean updateStatus(QfHrPersonM t) {
        QfHrPersonM QfHrPersonM2 = (QfHrPersonM)((Object)((QfHrPersonMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == QfHrPersonM2) {
            return false;
        }
        QfHrPersonM2.setStatus(QfHrPersonM2.getStatus() == 0 ? 1 : 0);
        int i = ((QfHrPersonMDao)this.baseMapper).updateById((Object)QfHrPersonM2);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfHrPersonM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List QfHrPersonMS = ((QfHrPersonMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfHrPersonMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfHrPersonMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfHrPersonM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List QfHrPersonMS = ((QfHrPersonMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)QfHrPersonMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfHrPersonMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }

    @Override
    public List<ReportVo> getHrReportVo(DataInfoVo dataInfoVo, String subjectCode) {
        List<QfHrPersonD> personDList = this.personDManager.findBySubjectCode(dataInfoVo, subjectCode);
        if (CollectionUtils.isEmpty(personDList)) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        personDList.forEach(personInfo -> {
            ReportVo reportVo = new ReportVo();
            reportVo.setActual(personInfo.getActual());
            reportVo.setActualYtd(personInfo.getActualYtd());
            reportVo.setEnterpriseCode(personInfo.getEnterpriseCode());
            reportVo.setSubjectCode(subjectCode);
            list.add(reportVo);
        });
        return list;
    }
}

