package com.artfess.report.config;

import com.artfess.base.jwt.JwtTokenHandler;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.TokenUtils;
import org.jeecg.modules.jmreport.api.JmReportTokenServiceI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * 自定义积木报表鉴权(如果不进行自定义，则所有请求不做权限控制)
 * 1.自定义获取登录token
 * 2.自定义获取登录用户
 */
@Component
class JimuReportTokenConfig implements JmReportTokenServiceI {

    @Autowired
    JwtTokenHandler jwtTokenHandler;

    @Override
    public String getToken(HttpServletRequest request) {
        String token = request.getHeader("Authorization");

        if (StringUtil.isEmpty(token)) {
            token = TokenUtils.getTokenByRequest(request);
        } else {
            token = token.substring(7);
        }
        return token;
    }

    @Override
    public String getUsername(String token) {
        return jwtTokenHandler.getUsernameFromToken(token);
    }

    @Override
    public Boolean verifyToken(String token) {
        TokenUtils.jwtTokenRefresh(token);
        return true;
    }
}