/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.task.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cqlt.task.manager.SchedulerTaskLogManager;
import com.artfess.cqlt.task.manager.SchedulerTaskManager;
import com.artfess.cqlt.task.model.SchedulerTask;
import com.artfess.cqlt.task.model.SchedulerTaskLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.quartz.SchedulerException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/task/schedulerTask/v1/"})
@Api(tags={"\u6570\u636e\u62bd\u53d6\u4efb\u52a1"})
@ApiGroup(group={"group_biz"})
public class SchedulerTaskController
extends BaseController<SchedulerTaskManager, SchedulerTask> {
    @Resource
    SchedulerTaskLogManager schedulerTaskLogManager;

    @PostMapping(value={"/sliceQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u6570\u636e\u62bd\u53d6\u4efb\u52a1")
    public PageList<SchedulerTask> sliceQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SchedulerTask> queryFilter) {
        return ((SchedulerTaskManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u6570\u636e\u62bd\u53d6\u4efb\u52a1")
    public CommonResult<String> create(@ApiParam(name="model", value="\u6570\u636e\u62bd\u53d6\u4efb\u52a1") @RequestBody SchedulerTask schedulerTask) {
        boolean rtn = BeanUtils.validClass((String)schedulerTask.getTaskClass());
        if (rtn) {
            boolean result = ((SchedulerTaskManager)this.baseService).insertSchedulerTask(schedulerTask);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u65b0\u589e\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25!");
            }
        } else {
            return new CommonResult(false, "\u9a8c\u8bc1\u7c7b\u5931\u8d25!", null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u6570\u636e\u62bd\u53d6\u4efb\u52a1")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u6570\u636e\u62bd\u53d6\u4efb\u52a1") @RequestBody SchedulerTask schedulerTask) {
        try {
            boolean result = ((SchedulerTaskManager)this.baseService).updateSchedulerTask(schedulerTask);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u66f4\u65b0\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u5931\u8d25!");
            }
            return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        try {
            boolean result = false;
            result = ((SchedulerTaskManager)this.baseService).deleteSchedulerTaskById(id);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
            }
            return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (SchedulerException e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/startUpJob"})
    @ApiOperation(value="\u542f\u52a8\u6570\u636e\u62bd\u53d6\u4efb\u52a1", httpMethod="POST", notes="\u542f\u52a8\u6570\u636e\u62bd\u53d6\u4efb\u52a1")
    public CommonResult<String> startUpJob(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=false) @RequestParam String taskId) throws SchedulerException {
        boolean result = ((SchedulerTaskManager)this.baseService).startUpJob(taskId);
        if (result) {
            return new CommonResult("\u542f\u52a8\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u542f\u52a8\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/stopJob"})
    @ApiOperation(value="\u505c\u6b62\u6570\u636e\u62bd\u53d6\u4efb\u52a1", httpMethod="POST", notes="\u505c\u6b62\u6570\u636e\u62bd\u53d6\u4efb\u52a1")
    public CommonResult<String> stopJob(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws SchedulerException {
        boolean result = ((SchedulerTaskManager)this.baseService).stopJob(taskId);
        if (result) {
            return new CommonResult("\u505c\u6b62\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u505c\u6b62\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/delJob"})
    @ApiOperation(value="\u6839\u636e\u4efb\u52a1id\u5220\u9664\u4efb\u52a1")
    public CommonResult<String> delJob(@ApiParam(name="taskId", value="\u4efb\u52a1id", required=true) @RequestParam String taskId) throws SchedulerException {
        boolean result = ((SchedulerTaskManager)this.baseService).delJob(taskId);
        if (result) {
            return new CommonResult("\u5220\u9664\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/sliceQueryLog"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u6570\u636e\u62bd\u53d6\u4efb\u52a1\u65e5\u5fd7")
    public PageList<SchedulerTaskLog> sliceQueryLog(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<SchedulerTaskLog> queryFilter) {
        return this.schedulerTaskLogManager.query(queryFilter);
    }
}

