/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.AnalyseTypeEnum;
import com.artfess.base.enums.FaTargetTypeEnum;
import com.artfess.base.enums.HrTargetTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfRzStatisticalDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfRzStatisticalManager;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfRzStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.DateReqVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.cqlt.vo.ReportVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfRzStatisticalManagerImpl
extends BaseManagerImpl<QfRzStatisticalDao, QfRzStatistical>
implements QfRzStatisticalManager {
    private static final Logger log = LoggerFactory.getLogger(QfRzStatisticalManagerImpl.class);
    @Autowired
    private SysSubjectTargetManager sysSubjectTargetManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveData(List<ReportVo> list, DataInfoVo dataInfoVo) {
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        ArrayList businessList = Lists.newArrayList();
        businessList.add("hr");
        List<SysSubjectTarget> targetList = this.sysSubjectTargetManager.getTargetList(businessList);
        if (CollectionUtils.isEmpty(targetList)) {
            return false;
        }
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        ArrayList dataList = Lists.newArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)dataInfoVo.getYear());
        query.eq((Object)"quarter_", (Object)dataInfoVo.getQuarter());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        List rzStatisticals = ((QfRzStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)rzStatisticals)) {
            targetList.forEach(target -> this.saveRzStatistical((SysSubjectTarget)((Object)target), dataList, list, dataInfoVo, enterpriseInfoMap));
        } else {
            Map<String, List<QfRzStatistical>> statisticalMap = rzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetId));
            targetList.forEach(target -> {
                List statisticalList = Lists.newArrayList();
                if (statisticalMap.containsKey(target.getId())) {
                    statisticalList = (List)statisticalMap.get(target.getId());
                }
                this.updateRzStatistical((SysSubjectTarget)((Object)target), dataList, statisticalList, list, dataInfoVo, enterpriseInfoMap);
            });
        }
        try {
            this.partitionSave(dataList);
            return true;
        }
        catch (Exception e) {
            log.error("\u4eba\u8d44\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        if (StringUtils.isEmpty((Object)t.getTargetId())) {
            t.setTargetLevel("1");
        }
        if (null == t.getYear() || t.getYear() <= 0) {
            int year2 = LocalDate.now().getYear();
            t.setYear(year2);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        List<QfRzStatistical> list = ((QfRzStatisticalDao)this.baseMapper).getGroupData(t);
        ArrayList resultList = Lists.newArrayList();
        Map<String, List<QfRzStatistical>> taggetMap = list.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetCode));
        for (HrTargetTypeEnum state : HrTargetTypeEnum.values()) {
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetId(state.getTargetId());
            resultFa.setTargetName(state.getTargetName());
            resultFa.setTargetNameEn(state.getTargetNameEn());
            resultFa.setTargetUnit(state.getTargetUnit());
            resultFa.setStaLat(state.getStaLat());
            resultFa.setType("1");
            resultFa.setSn(state.getType());
            List<String> stalat = Arrays.asList(state.getStaLat().split("\u3001"));
            List<String> targetCodes = Arrays.asList(state.getTargetCodes().split("\u3001"));
            ArrayList qfRzStatisticals = Lists.newArrayList();
            if (CollectionUtils.isEmpty(taggetMap)) {
                resultList.add(resultFa);
                continue;
            }
            for (String targetCode : targetCodes) {
                if (!taggetMap.containsKey(targetCode)) continue;
                qfRzStatisticals.addAll((Collection)taggetMap.get(targetCode));
            }
            Map<Integer, List<QfRzStatistical>> yearMap = qfRzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getYear));
            ArrayList reportRespVos = Lists.newArrayList();
            yearMap.forEach((year, v) -> {
                Map<String, QfRzStatistical> targetMap = ((List)yearMap.get(year)).stream().collect(Collectors.toMap(item -> item.getTargetCode(), item -> item));
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setYear((Integer)year);
                JSONObject json = new JSONObject();
                Integer count = 0;
                for (String targetCode : targetCodes) {
                    BigDecimal actual;
                    QfRzStatistical rzStatistical = targetMap.get(targetCode);
                    if ("%".equals(rzStatistical.getTargetUnit())) {
                        if (null != rzStatistical.getCount() && null != rzStatistical.getActual()) {
                            actual = rzStatistical.getActual().divide(new BigDecimal(rzStatistical.getCount()), 2, 4);
                            rzStatistical.setActual(actual);
                        }
                    } else if ("\u4e07\u6b27".equals(rzStatistical.getTargetUnit()) && null != rzStatistical.getActual()) {
                        actual = rzStatistical.getActual().divide(new BigDecimal(10000), 2, 4);
                        rzStatistical.setActual(actual);
                    }
                    json.put((String)stalat.get(count), (Object)rzStatistical.getActual());
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                faReportRespVo.setJson(json);
                reportRespVos.add(faReportRespVo);
            });
            resultFa.setResultData(reportRespVos);
            resultList.add(resultFa);
        }
        return resultList;
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        ArrayList resultList = Lists.newArrayList();
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        if (StringUtil.isEmpty((String)t.getEnterpriseCode()) || group.getCode().equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(group.getCode());
            t.setType(2);
        } else {
            t.setType(1);
        }
        HrTargetTypeEnum state = HrTargetTypeEnum.findByTargetId((String)t.getTargetId());
        List<String> targetCodes = Arrays.asList(state.getTargetCodes().split("\u3001"));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"code_", targetCodes);
        List targetList = this.sysSubjectTargetManager.list((Wrapper)queryWrapper);
        this.comparedAnalysis(t, resultList, targetCodes, targetList, "3");
        this.sequentialAnalysis(t, resultList, targetCodes, targetList, "4");
        this.monthAnalysis(t, resultList, state, targetCodes, "1");
        if (t.getType().equals(2)) {
            this.productionEnterpriseAnalysis(t, resultList, state, targetCodes, "6");
        }
        return resultList;
    }

    private void nonProductionEnterpriseAnalysis(ReportReqVo t, List<FaTargetRespVo> resultList, HrTargetTypeEnum state, List<String> targetCodes, String type) {
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setEnterpriseType(null);
        List<QfRzStatistical> yearData = ((QfRzStatisticalDao)this.baseMapper).enterpriseAnalysis(t, targetCodes);
        FaTargetRespVo resultFa = this.getFaTargetRespVo(state, type);
        resultFa.setTargetName("\u975e\u751f\u4ea7\u4f01\u4e1a\u5b9e\u9645\u5206\u6790");
        if (CollectionUtils.isEmpty(yearData)) {
            resultList.add(resultFa);
            return;
        }
        Map<String, List<QfRzStatistical>> taggetMap = yearData.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetCode));
        ArrayList qfRzStatisticals = Lists.newArrayList();
        for (String targetCode : targetCodes) {
            qfRzStatisticals.addAll((Collection)taggetMap.get(targetCode));
        }
        Map<String, List<QfRzStatistical>> yearMap = qfRzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getEnterpriseCode));
        ArrayList reportRespVos = Lists.newArrayList();
        yearMap.forEach((enterpriseCode, v) -> {
            Map<String, QfRzStatistical> targetMap = v.stream().collect(Collectors.toMap(item -> item.getTargetCode(), item -> item));
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setEnterpriseCode((String)enterpriseCode);
            JSONObject json = new JSONObject();
            for (String targetCode : targetCodes) {
                if (!taggetMap.containsKey(targetCode)) continue;
                QfRzStatistical rzStatistical = targetMap.get(targetCode);
                json.put(rzStatistical.getTargetName(), (Object)rzStatistical.getActual());
            }
            faReportRespVo.setJson(json);
            reportRespVos.add(faReportRespVo);
        });
        resultList.add(resultFa);
    }

    private void productionEnterpriseAnalysis(ReportReqVo t, List<FaTargetRespVo> resultList, HrTargetTypeEnum state, List<String> targetCodes, String type) {
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setEnterpriseType(1);
        List<QfRzStatistical> yearData = ((QfRzStatisticalDao)this.baseMapper).enterpriseAnalysis(t, targetCodes);
        FaTargetRespVo resultFa = this.getFaTargetRespVo(state, type);
        resultFa.setTargetName("\u751f\u4ea7\u4f01\u4e1a\u5b9e\u9645\u5206\u6790");
        if (CollectionUtils.isEmpty(yearData)) {
            resultList.add(resultFa);
            return;
        }
        if ("\u4e07\u6b27".equals(state.getTargetUnit())) {
            yearData.forEach(detail -> {
                BigDecimal actual = detail.getActual().divide(new BigDecimal(10000), 2, 4);
                detail.setActual(actual);
            });
        }
        Map<String, List<QfRzStatistical>> taggetMap = yearData.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetCode));
        ArrayList qfRzStatisticals = Lists.newArrayList();
        for (String targetCode : targetCodes) {
            qfRzStatisticals.addAll((Collection)taggetMap.get(targetCode));
        }
        Map<String, List<QfRzStatistical>> yearMap = qfRzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getEnterpriseCode));
        ArrayList reportRespVos = Lists.newArrayList();
        yearMap.forEach((enterpriseCode, v) -> {
            Map<String, QfRzStatistical> targetMap = v.stream().collect(Collectors.toMap(item -> item.getTargetCode(), item -> item));
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setEnterpriseCode((String)enterpriseCode);
            JSONObject json = new JSONObject();
            for (String targetCode : targetCodes) {
                if (!taggetMap.containsKey(targetCode)) continue;
                QfRzStatistical rzStatistical = targetMap.get(targetCode);
                if ("FE150\u3001FE151\u3001FE153\u3001FE154\u3001FE155\u3001FR156\u3001FE157".contains(targetCode)) {
                    rzStatistical.setTargetName(rzStatistical.getTargetName().substring(0, 4));
                }
                json.put(rzStatistical.getTargetName(), (Object)rzStatistical.getActual());
            }
            faReportRespVo.setJson(json);
            reportRespVos.add(faReportRespVo);
        });
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void sequentialAnalysis(ReportReqVo t, List<FaTargetRespVo> resultList, List<String> targetCodes, List<SysSubjectTarget> targetList, String type) {
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        List<FaReportRespVo> list = ((QfRzStatisticalDao)this.baseMapper).sequentialAnalysis(t, targetCodes);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, SysSubjectTarget> targetMap = targetList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<String, List<FaReportRespVo>> targetDataMap = list.stream().collect(Collectors.groupingBy(FaReportRespVo::getTargetId));
        targetDataMap.forEach((targetId, v) -> {
            if (!targetMap.containsKey(targetId)) {
                return;
            }
            SysSubjectTarget target = (SysSubjectTarget)((Object)((Object)targetMap.get(targetId)));
            ArrayList reportRespVos = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                Map<Integer, FaReportRespVo> respVoMap = v.stream().collect(Collectors.toMap(item -> item.getMonth(), item -> item));
                for (int i = 1; i < t.getEndMonth(); ++i) {
                    if (i == 1) continue;
                    FaReportRespVo faReportRespVo = new FaReportRespVo();
                    BigDecimal currentMonthActual = BigDecimal.ZERO;
                    BigDecimal lastMonthActual = BigDecimal.ZERO;
                    if (respVoMap.containsKey(i) && null != respVoMap.get(i).getActual()) {
                        currentMonthActual = respVoMap.get(i).getActual();
                    }
                    if (respVoMap.containsKey(i - 1) && null != respVoMap.get(i - 1).getActual()) {
                        lastMonthActual = respVoMap.get(i - 1).getActual();
                    }
                    faReportRespVo.setMonth(i);
                    faReportRespVo.setYear(t.getYear());
                    faReportRespVo.setTargetId(t.getTargetId());
                    faReportRespVo.setActual(currentMonthActual.subtract(lastMonthActual));
                    if (lastMonthActual.doubleValue() != 0.0) {
                        BigDecimal growthRate = currentMonthActual.subtract(lastMonthActual).divide(lastMonthActual, 2, 4).multiply(new BigDecimal(100));
                        faReportRespVo.setGrowthRate(growthRate);
                    } else {
                        faReportRespVo.setGrowthRate(BigDecimal.ZERO);
                    }
                    reportRespVos.add(faReportRespVo);
                }
            }
            FaTargetTypeEnum targetTypeEnum = FaTargetTypeEnum.getTarget((String)type);
            FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
            resultFa.setResultData(reportRespVos);
            resultFa.setTargetName(target.getName() + resultFa.getTargetName());
            resultFa.setTargetNameEn(target.getTargetNameEn() + resultFa.getTargetNameEn());
            resultFa.setStaLat("\u5b9e\u9645\u6570");
            resultList.add(resultFa);
        });
    }

    private void comparedAnalysis(ReportReqVo t, List<FaTargetRespVo> resultList, List<String> targetCodes, List<SysSubjectTarget> targetList, String type) {
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        List<FaReportRespVo> list = ((QfRzStatisticalDao)this.baseMapper).comparedAnalysis(t, targetCodes);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, SysSubjectTarget> targetMap = targetList.stream().collect(Collectors.toMap(item -> item.getId(), item -> item));
        Map<String, List<FaReportRespVo>> targetDataMap = list.stream().collect(Collectors.groupingBy(FaReportRespVo::getTargetId));
        JSONObject currentYearBeforeMonth = new JSONObject(true);
        JSONObject beforeYearBeforeMonth = new JSONObject(true);
        targetDataMap.forEach((targetId, v) -> {
            if (!targetMap.containsKey(targetId)) {
                return;
            }
            SysSubjectTarget target = (SysSubjectTarget)((Object)((Object)targetMap.get(targetId)));
            FaTargetTypeEnum targetTypeEnum = FaTargetTypeEnum.getTarget((String)type);
            FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, list);
            Map<Integer, List<FaReportRespVo>> monthMap = v.stream().collect(Collectors.groupingBy(FaReportRespVo::getMonth));
            ArrayList resultData = Lists.newArrayList();
            monthMap.forEach((month, data) -> {
                if (data.size() <= 1) {
                    return;
                }
                BigDecimal thisYearActual = ((FaReportRespVo)data.get(data.size() - 1)).getActual();
                BigDecimal lastYearActual = ((FaReportRespVo)data.get(0)).getActual();
                currentYearBeforeMonth.put(target.getCode() + month, (Object)thisYearActual);
                beforeYearBeforeMonth.put(target.getCode() + month, (Object)lastYearActual);
                if ("FE150\u3001FE151".contains(target.getCode())) {
                    if (currentYearBeforeMonth.containsKey((Object)(target.getCode() + (month - 1)))) {
                        thisYearActual = thisYearActual.subtract(currentYearBeforeMonth.getBigDecimal(target.getCode() + (month - 1)));
                        ((FaReportRespVo)data.get(data.size() - 1)).setActual(thisYearActual);
                    }
                    if (currentYearBeforeMonth.containsKey((Object)(target.getCode() + (month - 1)))) {
                        lastYearActual = lastYearActual.subtract(beforeYearBeforeMonth.getBigDecimal(target.getCode() + (month - 1)));
                        ((FaReportRespVo)data.get(0)).setActual(lastYearActual);
                    }
                }
                BigDecimal growthRate = null;
                growthRate = null == lastYearActual || lastYearActual.doubleValue() == 0.0 ? BigDecimal.ZERO : thisYearActual.subtract(lastYearActual).divide(lastYearActual, 2, 4).multiply(new BigDecimal(100));
                for (FaReportRespVo resp : data) {
                    resp.setGrowthRate(growthRate);
                    resultData.add(resp);
                }
            });
            resultData.sort(Comparator.comparing(FaReportRespVo::getMonth));
            resultFa.setResultData(resultData);
            resultFa.setTargetName(target.getName() + resultFa.getTargetName());
            resultFa.setTargetNameEn(target.getTargetNameEn() + resultFa.getTargetNameEn());
            resultFa.setStaLat("\u5b9e\u9645\u6570");
            resultList.add(resultFa);
        });
    }

    private void monthAnalysis(ReportReqVo t, List<FaTargetRespVo> resultList, HrTargetTypeEnum state, List<String> targetCodes, String type) {
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        List<QfRzStatistical> yearData = ((QfRzStatisticalDao)this.baseMapper).yearData(t, targetCodes);
        if (CollectionUtils.isEmpty(yearData)) {
            return;
        }
        if ("\u4e07\u6b27".equals(state.getTargetUnit())) {
            yearData.forEach(detail -> {
                BigDecimal actual = detail.getActual().divide(new BigDecimal(10000), 2, 4);
                detail.setActual(actual);
            });
        }
        Map<String, List<QfRzStatistical>> taggetMap = yearData.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetCode));
        FaTargetRespVo resultFa = this.getFaTargetRespVo(state, type);
        ArrayList qfRzStatisticals = Lists.newArrayList();
        for (String targetCode : targetCodes) {
            qfRzStatisticals.addAll((Collection)taggetMap.get(targetCode));
        }
        Map<Integer, List<QfRzStatistical>> yearMap = qfRzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getMonth));
        ArrayList reportRespVos = Lists.newArrayList();
        JSONObject beforeJson = new JSONObject(true);
        yearMap.forEach((month, v) -> {
            Map<String, QfRzStatistical> targetMap = v.stream().collect(Collectors.toMap(item -> item.getTargetCode(), item -> item));
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setMonth((Integer)month);
            JSONObject json = new JSONObject(true);
            for (String targetCode : targetCodes) {
                if (!taggetMap.containsKey(targetCode)) continue;
                QfRzStatistical rzStatistical = targetMap.get(targetCode);
                if ("FE150\u3001FE151\u3001FE153\u3001FE154\u3001FE155\u3001FE156\u3001FE157".contains(targetCode)) {
                    rzStatistical.setTargetName(rzStatistical.getTargetName().substring(0, 4));
                }
                beforeJson.put(targetCode + month, (Object)rzStatistical.getActual());
                faReportRespVo.setYear(rzStatistical.getYear());
                json.put(rzStatistical.getTargetName(), (Object)rzStatistical.getActual());
                if (!"FE150\u3001FE151\u3001FE152\u3001FE153\u3001FE155\u3001FE157".contains(targetCode) || !beforeJson.containsKey((Object)(targetCode + (month - 1)))) continue;
                json.put(rzStatistical.getTargetName(), (Object)rzStatistical.getActual().subtract(beforeJson.getBigDecimal(targetCode + (month - 1))));
            }
            faReportRespVo.setJson(json);
            reportRespVos.add(faReportRespVo);
        });
        resultFa.setResultData(reportRespVos);
        resultFa.setTargetName("\u5f53\u6708\u5b9e\u9645");
        resultList.add(resultFa);
    }

    private FaTargetRespVo getFaTargetRespVo(HrTargetTypeEnum state, String type) {
        FaTargetTypeEnum targetTypeEnum = FaTargetTypeEnum.getTarget((String)type);
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetId(state.getTargetId());
        resultFa.setTargetUnit(state.getTargetUnit());
        resultFa.setStaLat(state.getStaLat());
        resultFa.setType(type);
        resultFa.setSn(state.getType());
        if (!StringUtils.isEmpty((Object)state.getTargetUnit()) && "\u6b27".equals(state.getTargetUnit())) {
            resultFa.setTargetUnit("\u4e07\u6b27");
        }
        return resultFa;
    }

    @Override
    public List<FaTargetRespVo> enterpriseData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        ArrayList resultList = Lists.newArrayList();
        int year = LocalDate.now().getYear();
        t.setYear(year);
        HrTargetTypeEnum state = HrTargetTypeEnum.findByTargetId((String)t.getTargetId());
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetId(state.getTargetId());
        resultFa.setTargetName(state.getTargetName());
        resultFa.setTargetNameEn(state.getTargetNameEn());
        resultFa.setTargetUnit(state.getTargetUnit());
        if (!StringUtils.isEmpty((Object)state.getTargetUnit()) && "\u6b27".equals(state.getTargetUnit())) {
            resultFa.setTargetUnit("\u4e07\u6b27");
        }
        resultFa.setStaLat(state.getStaLat());
        resultFa.setType("5");
        resultFa.setSn(state.getType());
        List<String> stalat = Arrays.asList(state.getStaLat().split("\u3001"));
        List<String> targetCodes = Arrays.asList(state.getTargetCodes().split("\u3001"));
        List<QfRzStatistical> enterpriseData = ((QfRzStatisticalDao)this.baseMapper).enterpriseData(t, targetCodes);
        Map<String, List<QfRzStatistical>> taggetMap = enterpriseData.stream().collect(Collectors.groupingBy(QfRzStatistical::getTargetCode));
        ArrayList qfRzStatisticals = Lists.newArrayList();
        for (String targetCode : targetCodes) {
            qfRzStatisticals.addAll((Collection)taggetMap.get(targetCode));
        }
        Map<String, List<QfRzStatistical>> enterpriseCodeMap = qfRzStatisticals.stream().collect(Collectors.groupingBy(QfRzStatistical::getEnterpriseCode));
        ArrayList reportRespVos = Lists.newArrayList();
        enterpriseCodeMap.forEach((enterpriseCode, v) -> {
            Map<String, QfRzStatistical> targetMap = ((List)enterpriseCodeMap.get(enterpriseCode)).stream().collect(Collectors.toMap(item -> item.getTargetCode(), item -> item));
            FaReportRespVo faReportRespVo = new FaReportRespVo();
            faReportRespVo.setEnterpriseCode((String)enterpriseCode);
            JSONObject json = new JSONObject();
            Integer count = 0;
            for (String targetCode : targetCodes) {
                BigDecimal actual;
                QfRzStatistical rzStatistical = targetMap.get(targetCode);
                if ("%".equals(rzStatistical.getTargetUnit())) {
                    if (null != rzStatistical.getCount() && null != rzStatistical.getActual()) {
                        actual = rzStatistical.getActual().divide(new BigDecimal(rzStatistical.getCount()), 2, 4);
                        rzStatistical.setActual(actual);
                    }
                } else if (null != rzStatistical.getCount() && null != rzStatistical.getActual()) {
                    actual = rzStatistical.getActual().divide(new BigDecimal(10000), 2, 4);
                    rzStatistical.setActual(actual);
                }
                json.put((String)stalat.get(count), (Object)rzStatistical.getActual());
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
            }
            faReportRespVo.setJson(json);
            reportRespVos.add(faReportRespVo);
        });
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
        return resultList;
    }

    private void updateRzStatistical(SysSubjectTarget target, List<QfRzStatistical> dataList, List<QfRzStatistical> statisticalList, List<ReportVo> list, DataInfoVo dataInfoVo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        if (CollectionUtils.isEmpty(statisticalList)) {
            return;
        }
        Map<String, List<QfRzStatistical>> statisticalMap = statisticalList.stream().collect(Collectors.groupingBy(QfRzStatistical::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        Map<String, List<ReportVo>> enterpriseReportMap = list.stream().collect(Collectors.groupingBy(ReportVo::getEnterpriseCode));
        enterpriseReportMap.forEach((enterpriseCode, financialVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            List reportVos = (List)enterpriseReportMap.get(enterpriseCode);
            if (statisticalMap.containsKey(enterpriseCode)) {
                List statisticals = (List)statisticalMap.get(enterpriseCode);
                Map<String, QfRzStatistical> faMap = statisticals.stream().collect(Collectors.toMap(item -> item.getTargetId(), item -> item));
                QfRzStatistical rzStatistical = null;
                if (faMap.containsKey(target.getId())) {
                    rzStatistical = faMap.get(target.getId());
                    rzStatistical.setTempCalculation(targetCalculation);
                } else {
                    rzStatistical = new QfRzStatistical();
                    rzStatistical.setTempCalculation(targetCalculation);
                    rzStatistical.setEnterpriseCode((String)enterpriseCode);
                    this.createInfo(target, dataInfoVo, rzStatistical);
                }
                if (!StringUtil.isNotEmpty((String)target.getAnalyseType()) || !AnalyseTypeEnum.getAreaType().contains(target.getAnalyseType())) {
                    if (!StringUtil.isEmpty((String)qfEnterpriseInfo.getContinent())) {
                        rzStatistical.setEnterpriseArea(Integer.parseInt(qfEnterpriseInfo.getContinent()));
                    }
                    rzStatistical.setEnterpriseType(qfEnterpriseInfo.getBusinessType());
                    dataList.add(rzStatistical);
                }
                this.calculateData(targetCalculation, expressionKey, reportVos, rzStatistical);
                rzStatistical.setTempCalculation(targetCalculation);
                dataList.add(rzStatistical);
            }
        });
    }

    private void saveRzStatistical(SysSubjectTarget target, List<QfRzStatistical> dataList, List<ReportVo> list, DataInfoVo dataInfoVo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        Map<String, List<ReportVo>> enterpriseMap = list.stream().collect(Collectors.groupingBy(ReportVo::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseMap.forEach((enterpriseCode, rzVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            QfRzStatistical rzStatistical = new QfRzStatistical();
            rzStatistical.setTempCalculation(targetCalculation);
            this.createInfo(target, dataInfoVo, rzStatistical);
            this.calculateData(targetCalculation, expressionKey, (List<ReportVo>)rzVoList, rzStatistical);
            if (!StringUtil.isNotEmpty((String)target.getAnalyseType()) || !AnalyseTypeEnum.getAreaType().contains(target.getAnalyseType())) {
                if (!StringUtil.isEmpty((String)qfEnterpriseInfo.getContinent())) {
                    rzStatistical.setEnterpriseArea(Integer.parseInt(qfEnterpriseInfo.getContinent()));
                }
                rzStatistical.setEnterpriseType(qfEnterpriseInfo.getBusinessType());
                rzStatistical.setEnterpriseCode((String)enterpriseCode);
                dataList.add(rzStatistical);
            }
        });
    }

    private void calculateData(String targetCalculation, List<String> expressionKey, List<ReportVo> financialVoList, QfRzStatistical rzStatistical) {
        Integer dataType = 1;
        String targetCalculationJson = rzStatistical.getTargetCalculation();
        Map map = (Map)JSONObject.parseObject((String)targetCalculationJson, Map.class);
        if (CollectionUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        }
        HashMap targetCalculationMap = Maps.newHashMap();
        Map finalMap = map;
        expressionKey.forEach(key -> {
            if (StringUtils.isEmpty((Object)key)) {
                return;
            }
            key = "U" + key;
            for (ReportVo financialVo : financialVoList) {
                if (StringUtils.isEmpty((Object)financialVo.getSubjectCode()) || !financialVo.getSubjectCode().equals(key.substring(1))) continue;
                if (dataType == 1 && null == financialVo.getActualYtd()) {
                    financialVo.setActual(BigDecimal.ZERO);
                }
                if (dataType == 2 && null == financialVo.getBudget()) {
                    financialVo.setBudget(BigDecimal.ZERO);
                }
                if (CollectionUtils.isEmpty((Map)finalMap)) {
                    targetCalculationMap.put(key, dataType == 1 ? financialVo.getActualYtd() : financialVo.getBudget());
                    finalMap.put(dataType, targetCalculationMap);
                } else {
                    Map stringBigDecimalMap = (Map)finalMap.get(dataType);
                    if (!CollectionUtils.isEmpty((Map)stringBigDecimalMap)) {
                        for (Map.Entry entry : stringBigDecimalMap.entrySet()) {
                            if (!key.equals(entry.getKey())) continue;
                            targetCalculationMap.put(entry.getKey(), dataType == 1 ? financialVo.getActualYtd() : financialVo.getBudget());
                        }
                        if (!targetCalculationMap.containsKey(key)) {
                            targetCalculationMap.put(key, dataType == 1 ? financialVo.getActualYtd() : financialVo.getBudget());
                        }
                        finalMap.put(dataType, targetCalculationMap);
                    } else {
                        targetCalculationMap.put(key, dataType == 1 ? financialVo.getActualYtd() : financialVo.getBudget());
                        finalMap.put(dataType, targetCalculationMap);
                    }
                }
                if (expressionKey.size() != targetCalculationMap.size()) continue;
            }
        });
        for (String key2 : expressionKey) {
            key2 = "U" + key2;
            if (targetCalculationMap.containsKey(key2)) continue;
            targetCalculationMap.put(key2, BigDecimal.ZERO);
        }
        targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)targetCalculation);
        log.info("expressionKey:{},targetCalculation:{},targetCalculationMap:{}", new Object[]{expressionKey, targetCalculation, targetCalculationMap});
        rzStatistical.setTargetCalculation(JSON.toJSONString((Object)finalMap));
        if (!StringUtil.isNotEmpty((String)targetCalculation)) {
            return;
        }
        if (expressionKey.size() == targetCalculationMap.size()) {
            int margin = 4;
            if ("\u4eba".equals(rzStatistical.getTargetUnit())) {
                margin = 0;
            }
            BigDecimal bigDecimal = CommonUtil.convertToCode((String)targetCalculation, (Map)targetCalculationMap, (int)margin);
            if (StringUtil.isNotEmpty((String)rzStatistical.getTargetCalculation()) && "%".equals(rzStatistical.getTargetUnit())) {
                bigDecimal = bigDecimal.multiply(new BigDecimal(100));
            }
            rzStatistical.setActual(bigDecimal);
        }
    }

    private void createInfo(SysSubjectTarget target, DataInfoVo dataInfoVo, QfRzStatistical rzStatistical) {
        rzStatistical.setTargetId(target.getId());
        rzStatistical.setTargetLevel(target.getTargetLevel());
        rzStatistical.setTargetName(target.getName());
        rzStatistical.setTargetNameEn(target.getTargetNameEn());
        rzStatistical.setTargetUnit(target.getUnit());
        rzStatistical.setType(target.getType());
        rzStatistical.setStaLat(target.getStaLat());
        rzStatistical.setLargerType(target.getLargerType());
        rzStatistical.setParentTargetId(target.getParentId());
        rzStatistical.setYear(dataInfoVo.getYear());
        rzStatistical.setQuarter(dataInfoVo.getQuarter());
        rzStatistical.setMonth(dataInfoVo.getMonth());
    }

    private void partitionSave(List<QfRzStatistical> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }
}

