package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 运营统计请求参数vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="运营统计请求参数vo")
public class OpReportReqVo {

    @ApiModelProperty(value = "年份")
    private Integer year;

    @ApiModelProperty(value = "起始年份")
    private Integer startYear;

    @ApiModelProperty(value = "截止年份")
    private Integer endYear;

    @ApiModelProperty(value = "季度")
    private Integer quarter;

    @ApiModelProperty(value = "起始季度")
    private Integer startQuarter;

    @ApiModelProperty(value = "截止季度")
    private Integer endQuarter;

    @ApiModelProperty(value = "月份")
    private Integer month;

    @ApiModelProperty(value = "起始月份")
    private Integer startMonth;

    @ApiModelProperty(value = "截止月份")
    private Integer endMonth;

    @ApiModelProperty(value = "指标id")
    private String targetId;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）", hidden = true)
    private Integer enterpriseType;

    @ApiModelProperty(value = "产品:1:密封条,2:胶料,3:建筑,4:工业,5:非汽车")
    private Integer dataType;

    @ApiModelProperty(value = "区域类型（0：亚洲区域，1：欧洲区域，3：美洲区域")
    private String analyseType;

    @ApiModelProperty("产品:1:密封条,2:胶料,3:建筑,4:工业,5:非汽车")
    private String product;

    @ApiModelProperty("客户编码")
    private String customer;

    @ApiModelProperty(value = "企业code")
    private String enterpriseCode;

    @ApiModelProperty(value = "类别")
    private String subjectCode;

    @ApiModelProperty(value = "时间参数")
    private List<OpQueryReqVo> queryList;

}
