package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 报表填报范围
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@ApiModel(value="QfReportRange对象", description="报表填报范围")
@Data
public class QfReportRange extends BaseModel<QfReportRange> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报表id")
    @TableField("report_id_")
    @NotNull(message = "QfReportRange.reportId", groups = {AddGroup.class})
    private String reportId;

    @ApiModelProperty(value = "填报范围企业id")
    @TableField("enterprise_id_")
    @NotNull(message = "QfReportRange.enterpriseId", groups = {AddGroup.class})
    private String enterpriseId;

    @ApiModelProperty(value = "填报范围企业编码")
    @TableField("enterprise_code_")
    @NotNull(message = "QfReportRange.enterpriseCode", groups = {AddGroup.class})
    private String enterpriseCode;

    @ApiModelProperty(value = "填报范围企业名称")
    @TableField(exist=false)
    private String name;
    @ApiModelProperty(value = "填报范围企业英文名称")
    @TableField(exist=false)
    private String nameEn;

}
