package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--企业销售数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Data
@ApiModel(value="QfOperationSalesD对象", description="运营--企业销售数据填报详情表")
public class QfOperationSalesD extends BaseModel<QfOperationSalesD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "enterpriseCode", column = "A")
    @ApiModelProperty(value = "子企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "产品（预留字段）")
    @TableField("product_")
    private String product;

    @Excel(name = "Actual", column = "B")
    @ApiModelProperty(value = "当月实际销售额")
    @TableField("actual_")
    private BigDecimal actual;

    @Excel(name = "Budget", column = "C")
    @ApiModelProperty(value = "当月预算销售额")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "Deviation abs.", column = "D")
    @ApiModelProperty(value = "当月销售差额")
    @TableField("deviation_")
    private BigDecimal deviation;

    @Excel(name = "Deviation(%)", column = "E")
    @ApiModelProperty(value = "当月销售偏差率(%)")
    @TableField("deviation_rate_")
    private BigDecimal deviationRate;


    @Excel(name = "ActualYTD", column = "F")
    @ApiModelProperty(value = "当年累计实际销售额")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @Excel(name = "BudgetYTD", column = "G")
    @ApiModelProperty(value = "当年累计预算销售额")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @Excel(name = "DeviationabsYtd", column = "H")
    @ApiModelProperty(value = "当年累计销售差额")
    @TableField("deviation_ytd_")
    private BigDecimal deviationYtd;

    @Excel(name = "DeviationYtd(%)", column = "I")
    @ApiModelProperty(value = "当年销售偏差率(%)")
    @TableField("deviation_rate_ytd_")
    private BigDecimal deviationRateYtd;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
