package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--集团持续改进数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationCipD对象", description="运营--集团持续改进数据填报详情表")
public class QfOperationCipD extends BaseModel<QfOperationCipD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @Excel(name = "subjectName", column = "B")
    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;

    @Excel(name = "subjectNameEn", column = "A")
    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @Excel(name = "budget", column = "C")
    @ApiModelProperty(value = "预算数据")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "actual", column = "D")
    @ApiModelProperty(value = "实际数据")
    @TableField("actual_")
    private BigDecimal actual;


    @Excel(name = "variance", column = "E")
    @ApiModelProperty(value = "差额（实际-预算）")
    @TableField("variance_")
    private BigDecimal variance;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
