package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.LoanDataTypeEnum;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLoanMDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.manager.QfFinanceLoanMManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceLoanD;
import com.artfess.cqlt.model.QfFinanceLoanM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Map;

/**
 * 资金--贷款填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Service
public class QfFinanceLoanMManagerImpl extends BaseManagerImpl<QfFinanceLoanMDao, QfFinanceLoanM> implements QfFinanceLoanMManager {

    @Autowired
    private QfFinanceLoanDManager operationKpiDManager;

    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfFinanceLoanD> list, String mainId) {
        QfFinanceLoanM qfOperationKpiM = this.baseMapper.selectById(mainId);
        Assert.notNull(qfOperationKpiM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationKpiM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfFinanceLoanD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        operationKpiDManager.remove(queryWrapper);
        //获取境外企业
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoManager.getEnterpriseInfoMap(null);
        list.forEach(detail -> {
            if (enterpriseInfoMap.containsKey(detail.getEnterpriseCode())) {
                QfEnterpriseInfo qfEnterpriseInfo = enterpriseInfoMap.get(detail.getEnterpriseCode());
                detail.setEnterpriseNameEn(qfEnterpriseInfo.getNameEn());
            }
            detail.setType(LoanDataTypeEnum.getType(detail.getType()));
            detail.setFillDate(qfOperationKpiM.getFillDate());
            detail.setMainId(mainId);
        });
        boolean b = operationKpiDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfFinanceLoanM t) {
        QfFinanceLoanM qfOperationKpiM = baseMapper.selectById(t.getId());
        if(null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(qfOperationKpiM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfFinanceLoanM t) {
        QueryWrapper<QfFinanceLoanM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfFinanceLoanM> financeLoanMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(financeLoanMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfFinanceLoanM t) {
        QueryWrapper<QfFinanceLoanM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfFinanceLoanM> financeLoanMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(financeLoanMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }
}
