package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLeaseDDao;
import com.artfess.cqlt.dao.QfFinanceLeaseMDao;
import com.artfess.cqlt.manager.QfFinanceLeaseDManager;
import com.artfess.cqlt.model.QfFinanceLeaseD;
import com.artfess.cqlt.model.QfFinanceLeaseM;
import com.artfess.cqlt.vo.MoneyReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.util.List;

/**
 * 资金--融资租赁填报数据详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Service
public class QfFinanceLeaseDManagerImpl extends BaseManagerImpl<QfFinanceLeaseDDao, QfFinanceLeaseD> implements QfFinanceLeaseDManager {
    @Resource
    private QfFinanceLeaseMDao leaseMDao;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfFinanceLeaseM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfFinanceLeaseM QfFinanceLeaseM = leaseMDao.selectById(t.getId());
        Assert.notNull(QfFinanceLeaseM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(QfFinanceLeaseM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        List<QfFinanceLeaseD> list = t.getList();
        list.forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setFillDate(QfFinanceLeaseM.getFillDate());
        });
        boolean b = this.saveOrUpdateBatch(list);
        return b;
    }

    @Override
    public List<MoneyReportRespVo> companyYearData(ReportReqVo t) {
        //获取当前指标的年季月趋势数据
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }

        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 10);
        }
        return this.baseMapper.companyYearData(t);
    }

    @Override
    public List<MoneyReportRespVo> companyQuarterData(ReportReqVo t) {
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartQuarter() || null == t.getEndQuarter()) {
            t.setEndQuarter(4);
            t.setStartQuarter(1);
        }
        return this.baseMapper.companyQuarterData(t);
    }
}
