package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.ReportDataVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 人资--人员数据填报详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
public interface QfHrPersonDManager extends BaseManager<QfHrPersonD> {

    boolean batchSave(QfHrPersonM t);

    boolean batchUpdate(QfHrPersonM t);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfHrPersonD> list, String sheetName) throws IOException;

    List<JSONObject> detailQuery(List<QfHrPersonD> rows);

    List<ReportDataVo> getPersonDataList(List<String> strings, Integer fillYear, Integer endMonth);

    List<QfHrPersonD> findBySubjectCode(DataInfoVo dataInfoVo, String subjectCode);

}
