package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfRzStatistical;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 人资-大屏统计宽表 Mapper 接口
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-30
 */
public interface QfRzStatisticalDao extends BaseMapper<QfRzStatistical> {

    List<QfRzStatistical> getGroupData(@Param("vo") ReportReqVo t);

    List<FaReportRespVo> sequentialAnalysis(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

    List<FaReportRespVo> comparedAnalysis(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

    List<QfRzStatistical> yearData(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

    List<QfRzStatistical> enterpriseData(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

    List<QfRzStatistical> enterpriseAnalysis(@Param("vo") ReportReqVo t, @Param("targetCodes") List<String> targetCodes);

}
