package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.artfess.base.controller.BaseController;
import com.artfess.cqlt.model.QfFinanceCfS;
import com.artfess.cqlt.manager.QfFinanceCfSManager;

/**
 * 财务-现金流量汇总表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Slf4j
@RestController
@Api(tags = "财务--现金流量填报汇总表")
@RequestMapping("/qf/finance/cf/sum/v1/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfFinanceCfSController extends BaseController<QfFinanceCfSManager, QfFinanceCfS> {

}
