package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Set;

/**
 * 财务上报数据vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:57
 */
@Data
@ApiModel(value="上报数据vo")
public class ReportVo {

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    private Integer enterpriseType;

    @ApiModelProperty(value = "实际值")
    private BigDecimal actual;

    @ApiModelProperty(value = "预算值")
    private BigDecimal budget;

    @ApiModelProperty(value = "累计实际值")
    private BigDecimal actualYtd;

    @ApiModelProperty(value = "累计预算值")
    private BigDecimal budgetYtd;
    //集团层面 todo

    @ApiModelProperty(value = "科目编码")
    private String subjectCode;

    @ApiModelProperty(value = "大屏类型（1:汇总数据，2：企业数据）")
    private Integer dataType;

    private String targetName;

    @ApiModelProperty(value = "科目编码")
    private Set<String> subjectCodes;


}
