package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 银行贷款明细vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="财务大屏统计请求参数vo")
public class BankLoanDetailRespVo {

    @ApiModelProperty(value = "银行名称")
    private String bankName;

    @ApiModelProperty(value = "公司名称")
    private String enterpriseName;

    @ApiModelProperty(value = "公司代码")
    private String enterpriseCode;

    @ApiModelProperty(value = "借款余额(万欧)（内保外贷指标显示该字段）")
    private BigDecimal borrowingBalance;

    @ApiModelProperty(value = "担保金额（万欧）（内保外贷指标显示该字段）")
    private BigDecimal guaranteeAmount;

    @ApiModelProperty(value = "借款余额（万欧）(自主融资指标显示该字段)")
    private BigDecimal loanBalance;

    @ApiModelProperty(value = "利率（%）")
    private String interestRate;

    @ApiModelProperty(value = "借款起期")
    private LocalDate startDate;

    @ApiModelProperty(value = "借款止期")
    private LocalDate endDate;
}
