package com.artfess.cqlt.task.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 抽取任务执行日志
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-10-18
 */
@TableName("BIZ_SCHEDULER_TASK_LOG")
@ApiModel(value="SchedulerTaskLog对象", description="抽取任务执行日志")
public class SchedulerTaskLog extends BaseModel<SchedulerTaskLog> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "任务ID")
    @TableField("task_id_")
    private String taskId;

    @ApiModelProperty(value = "调度id")
    @TableField("sys_joblog_id_")
    private String sysJoblogId;

    @ApiModelProperty(value = "执行开始时间")
    @TableField("start_time_")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "执行结束时间")
    @TableField("end_time_")
    private LocalDateTime endTime;

    @ApiModelProperty(value = "执行结果")
    @TableField("result_")
    private String result;

    @ApiModelProperty(value = "状态（1：成功，0：失败）")
    @TableField("status_")
    private Integer status;

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskId() {
        return taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getSysJoblogId() {
        return sysJoblogId;
    }

    public void setSysJoblogId(String sysJoblogId) {
        this.sysJoblogId = sysJoblogId;
    }

    public LocalDateTime getStartTime() {
        return startTime;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public String getResult() {
        return result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    @Override
    public String toString() {
        return "SchedulerTaskLog{" +
                "id='" + id + '\'' +
                ", taskId='" + taskId + '\'' +
                ", sysJoblogId='" + sysJoblogId + '\'' +
                ", startTime=" + startTime +
                ", endTime=" + endTime +
                ", result='" + result + '\'' +
                ", status=" + status +
                '}';
    }
}
