package com.artfess.cqlt.task.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 数据抽取任务信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-12-16
 */
@TableName("BIZ_SCHEDULER_TASK")
@ApiModel(value="SchedulerTask对象", description="数据抽取任务信息")
public class SchedulerTask extends AutoFillModel<SchedulerTask> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "任务名称")
    @TableField("task_name_")
    private String taskName;

    @ApiModelProperty(value = "任务执行类名称")
    @TableField("task_class_")
    private String taskClass;

    @ApiModelProperty(value = "任务类型（1：定时任务，2：非定时任务）")
    @TableField("task_type_")
    private Integer taskType;

    @ApiModelProperty(value = "任务调用频率")
    @TableField("task_rate_")
    private Integer taskRate;

    @ApiModelProperty(value = "任务调用频率单位(m:分钟，h:小时，d:天，w:周，M:月，Y：年)")
    @TableField("task_rate_unit_")
    private String taskRateUnit;

    @ApiModelProperty(value = "任务运行状态( NONE：停止, NORMAL：运行,PAUSED：暂停)")
    @TableField("task_status_")
    private String taskStatus;

    @ApiModelProperty(value = "任务说明")
    @TableField("task_memo_")
    private String taskMemo;

    @ApiModelProperty(value = "源数据源编码")
    @TableField("source_code_")
    private String sourceCode;

    @ApiModelProperty(value = "源表名称")
    @TableField("source_table_")
    private String sourceTable;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskClass() {
        return taskClass;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    public Integer getTaskRate() {
        return taskRate;
    }

    public void setTaskRate(Integer taskRate) {
        this.taskRate = taskRate;
    }

    public String getTaskRateUnit() {
        return taskRateUnit;
    }

    public void setTaskRateUnit(String taskRateUnit) {
        this.taskRateUnit = taskRateUnit;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskMemo() {
        return taskMemo;
    }

    public void setTaskMemo(String taskMemo) {
        this.taskMemo = taskMemo;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    public String getSourceTable() {
        return sourceTable;
    }

    public void setSourceTable(String sourceTable) {
        this.sourceTable = sourceTable;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "SchedulerTask{" +
                "id='" + id + '\'' +
                ", taskName='" + taskName + '\'' +
                ", taskClass='" + taskClass + '\'' +
                ", taskType='" + taskType + '\'' +
                ", taskRate=" + taskRate +
                ", taskRateUnit='" + taskRateUnit + '\'' +
                ", taskStatus='" + taskStatus + '\'' +
                ", taskMemo='" + taskMemo + '\'' +
                ", sourceCode='" + sourceCode + '\'' +
                ", sourceTable='" + sourceTable + '\'' +
                '}';
    }
}
