package com.artfess.cqlt.task.job;

import com.artfess.cqlt.manager.BizOrgManager;
import com.artfess.job.model.BaseJob;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 泛微组织数据同步
 */
@Slf4j
public class AsyncOrgJob extends BaseJob {

	@Resource
	private BizOrgManager orgManager;


	@Override
	@Transactional(rollbackFor = Exception.class)
	public void executeJob(JobExecutionContext context)  {
		log.info("泛微组织同步");
		try {
			Boolean result = orgManager.sync();
			if(result) {
				log.info("泛微组织同步成功");
			}
		}catch (Exception e) {
			log.error("泛微组织同步失败：{}", e.getMessage());
		}

		JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
	}

}
