package com.artfess.cqlt.model;

import java.math.BigDecimal;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 财务--国资委子企业季度填报主表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceSasacCompanyM对象", description="财务--国资委子企业季度填报主表")
public class QfFinanceSasacCompanyM extends AutoFillModel<QfFinanceSasacCompanyM> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报表ID")
    @TableField("report_id_")
    private String reportId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField("fill_quarter_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "填报单位")
    @TableField("fill_company_")
    private String fillCompany;

    @ApiModelProperty(value = "填报人")
    @TableField("fill_user_")
    private String fillUser;

    @ApiModelProperty(value = "审核人")
    @TableField("audit_user_")
    private String auditUser;

    @ApiModelProperty(value = "联系电话")
    @TableField("tel_")
    private String tel;

    @ApiModelProperty(value = "去年同期平均汇率")
    @TableField("lastYear_avgRate_")
    private BigDecimal lastYearAvgRate;

    @ApiModelProperty(value = "去年同期期末汇率")
    @TableField("lastYear_endRate_")
    private BigDecimal lastYearEndRate;

    @ApiModelProperty(value = "去年累计平均汇率")
    @TableField("lastYear_ytd_avgRate_")
    private BigDecimal lastYearYtdAvgRate;

    @ApiModelProperty(value = "去年累计期末汇率")
    @TableField("lastYear_ytd_endRate_")
    private BigDecimal lastYearYtdEndRate;

    @ApiModelProperty(value = "本年同期平均汇率")
    @TableField("year_avgRate_")
    private BigDecimal yearAvgRate;

    @ApiModelProperty(value = "本年同期期末汇率")
    @TableField("year_endRate_")
    private BigDecimal yearEndRate;

    @ApiModelProperty(value = "本年累计平均汇率")
    @TableField("year_ytd_avgRate_")
    private BigDecimal yearYtdAvgRate;

    @ApiModelProperty(value = "本年累计期末汇率")
    @TableField("year_ytd_endRate_")
    private BigDecimal yearYtdEndRate;

    @ApiModelProperty(value = "报表状态【字典】（0：临时，1：正式）")
    @TableField("status_")
    private Integer status;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
