package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 财务-现金流量预算填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceCfBudgetD对象", description="财务-现金流量预算填报详情表")
public class QfFinanceCfBudgetD extends BaseModel<QfFinanceCfBudgetD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @ApiModelProperty(value = "当月预算数据")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "当年累计预算数据")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    protected Integer sn;

    @ApiModelProperty(value = "所在列")
    @TableField("column_")
    protected Integer column;
}
