package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.SysSubjectTargetDao;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.SysSubjectTarget;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 统计分析指标库表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Service
public class SysSubjectTargetManagerImpl extends BaseManagerImpl<SysSubjectTargetDao, SysSubjectTarget> implements SysSubjectTargetManager {

    @Override
    public List<SysSubjectTarget> getTargetList(List<String> businessList) {
        return this.baseMapper.getTargetList(businessList);
    }

    @Override
    public List<SysSubjectTarget> lowerLevelTargetList(String subjectId) {
        return this.baseMapper.lowerLevelTargetList(subjectId);
    }
}
