package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSopMDao;
import com.artfess.cqlt.manager.QfOperationSopDManager;
import com.artfess.cqlt.manager.QfOperationSopMManager;
import com.artfess.cqlt.model.QfOperationSalesProductD;
import com.artfess.cqlt.model.QfOperationSalesProductM;
import com.artfess.cqlt.model.QfOperationSopD;
import com.artfess.cqlt.model.QfOperationSopM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 运营--新项目收入贡献填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Service
public class QfOperationSopMManagerImpl extends BaseManagerImpl<QfOperationSopMDao, QfOperationSopM> implements QfOperationSopMManager {

    @Autowired
    private QfOperationSopDManager sopDManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfOperationSopD> list, String mainId) {
        QfOperationSopM qfOperationSopM = this.baseMapper.selectById(mainId);
        Assert.notNull(qfOperationSopM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationSopM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfOperationSopD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        sopDManager.remove(queryWrapper);
        Map<String, QfOperationSopD> historyMap = this.historyList(qfOperationSopM);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(qfOperationSopM.getFillDate());
            if (null == detail.getBudgetYtd()) {
                detail.setBudgetYtd(BigDecimal.ZERO);
            }
            if (null == detail.getActualYtd()) {
                detail.setActualYtd(BigDecimal.ZERO);
            }
            if (!historyMap.containsKey(detail.getCustomer())) {
                detail.setActual(detail.getActualYtd());
                detail.setBudget(detail.getActualYtd());
            } else {
                QfOperationSopD sopD = historyMap.get(detail.getCustomer());
                if (null == sopD.getBudgetYtd()) {
                    detail.setBudget(BigDecimal.ZERO);
                } else {
                    detail.setBudget(detail.getBudgetYtd().subtract(sopD.getBudgetYtd()));
                }
                if (null == sopD.getActualYtd()) {
                    detail.setActual(BigDecimal.ZERO);
                } else {
                    detail.setActual(detail.getActualYtd().subtract(sopD.getActualYtd()));
                }
                if (null == sopD) {
                    detail.setActual(detail.getActualYtd());
                    detail.setBudget(detail.getActualYtd());
                }
            }
        });
        boolean b = sopDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationSopM t) {
        QfOperationSopM qfOperationKpiM = baseMapper.selectById(t.getId());
        if(null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(qfOperationKpiM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfOperationSopM t) {
        QueryWrapper<QfOperationSopM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfOperationSopM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfOperationSopM t) {
        QueryWrapper<QfOperationSopM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfOperationSopM> qfOperationKpiMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    private Map<String, QfOperationSopD> historyList(QfOperationSopM operationSopM) {
        //获取上个月的数据
        List<QfOperationSopD> historyList = this.baseMapper.historyList(operationSopM.getFillMonth() - 1, operationSopM.getFillYear());
        if (CollectionUtils.isEmpty(historyList)) {
            return Maps.newHashMap();
        }
        Map<String, QfOperationSopD> historyProduct = historyList.stream().collect(Collectors.toMap(item -> item.getCustomer(), item -> item));
        return historyProduct;
    }

}
