package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinancePlSDao;
import com.artfess.cqlt.manager.QfFinancePlSManager;
import com.artfess.cqlt.model.QfFinancePlS;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.ReportReqVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

/**
 * 财务-利润汇总表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Service
public class QfFinancePlSManagerImpl extends BaseManagerImpl<QfFinancePlSDao, QfFinancePlS> implements QfFinancePlSManager {

    /**
     * DL0001  FE010
     * EB0001 FE014
     * EB0002  FE026
     * @param t
     * @param target
     * @return
     */
    @Override
    public BigDecimal getMeanRank(ReportReqVo t, SysSubjectTarget target) {
        BigDecimal meanRank = BigDecimal.ZERO;
        if(null == target){
            return meanRank;
        }
        QueryWrapper<QfFinancePlS> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getYear());
        queryWrapper.eq("fill_month_", 1);
        if("FE010".equals(target.getCode())){
            meanRank = new BigDecimal("28");
            queryWrapper.eq("subject_code_", "DL0001");
        }else if("FE014".equals(target.getCode())){
            meanRank = new BigDecimal("9");
            queryWrapper.eq("subject_code_", "EB0001");
        }else if("FE026".equals(target.getCode())){
            meanRank = new BigDecimal("3");
            queryWrapper.eq("subject_code_", "EB0002");
        }
        QfFinancePlS plS = this.baseMapper.selectOne(queryWrapper);
        if(null == plS) {
            return meanRank;
        }
        if(null == plS.getActualConsolidated()) {
            return meanRank;
        }
        return plS.getActualConsolidated().multiply(new BigDecimal(100));
    }
}
