package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfFinanceBsD;
import com.artfess.cqlt.model.QfFinanceBsM;
import com.artfess.cqlt.vo.ReportDataVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 财务-资产负债填报详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinanceBsDManager extends BaseManager<QfFinanceBsD> {

    boolean batchUpdate(QfFinanceBsM t);

    List<JSONObject> detailQuery(List<QfFinanceBsD> rows);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceBsD> rows, String sheetName) throws IOException;

    List<ReportDataVo> getBsDataList(List<String> strings, Integer fillYear, Integer endMonth);
}
