package com.artfess.cqlt.controller;


import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.enums.SubjectTypeEnum;
import com.artfess.base.model.CommonResult;
import com.artfess.cqlt.manager.QfOperatingStatisticalManager;
import com.artfess.cqlt.manager.QfSubjectInternationalInfoManager;
import com.artfess.cqlt.model.QfSubjectInternationalInfo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 运营主题 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-06-13
 */
@Slf4j
@RestController
@Api(tags = "大屏统计--运营主题")
@RequestMapping("/qf/operation/statistical/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfOperationStatisticalController {

    @Autowired
    private QfOperatingStatisticalManager statisticalManager;

    @Autowired
    private QfSubjectInternationalInfoManager subjectInternationalInfoManager;


    @PostMapping("/oneLevelData")
    @ApiOperation(value = "销售板块指标一级界面统计接口", response = OpTargetRespVo.class, notes = "包括持续改进类数据")
    public CommonResult<String> oneLevelData(@ApiParam(name = "model", value = "请求参数") @RequestBody OpReportReqVo t) {
        List<OpTargetRespVo> data = statisticalManager.data(t);
        //产品销售数据对比
        return CommonResult.success(data, null);
    }

    @PostMapping("/fromUnderData")
    @ApiOperation(value = "销售板块根据指标id获取当前指标分析)", notes = "包括持续改进类数据")
    public CommonResult<String> fromUnderData(@ApiParam(name = "model", value = "请求参数") @RequestBody OpReportReqVo t) {
        List<OpTargetRespVo> data = statisticalManager.fromUnderData(t);
        return CommonResult.success(data, null);
    }

    @PostMapping("/getSubjectList")
    @ApiOperation("获取所有持续改进类别")
    public CommonResult<List<QfSubjectInternationalInfo>> getSubjectList() {
        String type = SubjectTypeEnum.OP2.getType();
        List<QfSubjectInternationalInfo> list = subjectInternationalInfoManager.findByType(type);
        return CommonResult.success(list, null);
    }

    @PostMapping("/getProductList")
    @ApiOperation("获取所有产品")
    public CommonResult getProductList() {
        ProductSalesDataTypeEnum[] values = ProductSalesDataTypeEnum.values();
        JSONObject json = new JSONObject(true);
        for(ProductSalesDataTypeEnum productSalesDataTypeEnum:values){
            json.put(productSalesDataTypeEnum.getType(),productSalesDataTypeEnum.getDesc());
        }
        return CommonResult.success(json, null);
    }

}
