package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 大屏统计请求参数vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="大屏统计请求参数vo")
public class ReportReqVo {

    @ApiModelProperty(value = "年份")
    private Integer year;

    @ApiModelProperty(value = "季度趋势年份")
    private Integer quarterYear;

    @ApiModelProperty(value = "起始年份")
    private Integer startYear;

    @ApiModelProperty(value = "截止年份")
    private Integer endYear;

    @ApiModelProperty(value = "季度")
    private Integer quarter;

    @ApiModelProperty(value = "起始季度")
    private Integer startQuarter;

    @ApiModelProperty(value = "截止季度")
    private Integer endQuarter;

    @ApiModelProperty(value = "月份")
    private Integer month;

    @ApiModelProperty(value = "起始月份")
    private Integer startMonth;

    @ApiModelProperty(value = "截止月份")
    private Integer endMonth;

    @ApiModelProperty(value = "企业code")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业vo")
    private List<String> enterpriseCodes;

    @ApiModelProperty(value = "指标id")
    private String targetId;

    @ApiModelProperty(value = "大屏类型 2:集团驾驶舱，1:企业驾驶舱")
    private Integer type = 1;

    @ApiModelProperty(hidden = true)
    private String targetLevel;

    @ApiModelProperty(value = "指标id")
    private String parentTargetId;

    @ApiModelProperty(value = "区域类型（0：亚洲区域，1：欧洲区域，3：美洲区域")
    private String analyseType;

    @ApiModelProperty(value = "动态表名, 前缀")
    private String tableName;

    @ApiModelProperty("产品:1:密封条,2:胶料,3:建筑,4:工业,5:非汽车")
    private String product;

    @ApiModelProperty("客户编码")
    private String customer;

    @ApiModelProperty(value = "当前周")
    private Integer week;

    @ApiModelProperty(value = "预测周范围，最大10周")
    private List<Integer> planWeeks;

    @ApiModelProperty(value = "数据类型(1：企业数据，2：资金池公司汇总，3：公司阈值，4：集团汇总，5：集团阈值)")
    private Integer dataType;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）", hidden = true)
    private Integer enterpriseType;

    @ApiModelProperty(value = "时间参数")
    private List<QueryReqVo> queryList;



}
