package com.artfess.cqlt.vo;

import com.artfess.base.annotation.Excel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @author 黎沐华
 * @date 2023/2/24 10:55
 */
@Data
@ApiModel("年降数据填报Excel VO对象")
public class ReductionVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @Excel(name = "YearMonth", column = "B")
    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Product", column = "A")
    @ApiModelProperty(value = "产品")
    @TableField("customer_")
    private String customer;

    @Excel(name = "Actual", column = "C")
    @ApiModelProperty(value = "实际（百万欧元）")
    @TableField("actual_")
    private BigDecimal actual;

    @Excel(name = "Budget", column = "D")
    @ApiModelProperty(value = "预算（百万欧元）")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "实际占收入比例")
    @TableField("actual_rate_")
    private BigDecimal actualRate;

    @ApiModelProperty(value = "预算占收入比例")
    @TableField("budget_rate_")
    private BigDecimal budgetRate;

    @Excel(name = "Actual Rate", column = "E")
    @ApiModelProperty(value = "实际占收入比例, 字符串（%）")
    @TableField("actual_rate_")
    private String actualRateStr;

    @Excel(name = "Budget Rate", column = "F")
    @ApiModelProperty(value = "预算占收入比例, 字符串（%）")
    @TableField("budget_rate_")
    private String budgetRateStr;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
