package com.artfess.cqlt.vo;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--KPI数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-14
 */
@Data
@ApiModel(value="QfOperationKpiD对象", description="运营--KPI数据填报详情表")
public class KpiDetailVo extends BaseModel<KpiDetailVo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "主表ID")
    private String mainId;

    @Excel(name = "YearMonth", column = "B")
    @ApiModelProperty(value = "填报日期")
    private LocalDate fillDate;

    @Excel(name = "Company", column = "A")
    @ApiModelProperty(value = "子企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "转换率(%)")
    private BigDecimal trExfiAct;

    @Excel(name = "TR_exfi_act(%)", column = "C")
    @ApiModelProperty(value = "转换率(%)")
    private String trExfiActStr;

    @ApiModelProperty(value = "24小时设备综合效率(%)")
    private BigDecimal oee24ExEpdmAct;

    @Excel(name = "OEE24_ex_epdm_act(%)", column = "D")
    @ApiModelProperty(value = "24小时设备综合效率(%)")
    private String oee24ExEpdmActStr;

    @Excel(name = "CRj_exfi_act(件)", column = "E")
    @ApiModelProperty(value = "每百万件中客户拒绝件数(件)")
    private BigDecimal crjExfiAct;

    @Excel(name = "CC_exfi_act(次)", column = "F")
    @ApiModelProperty(value = "每百万件客户抱怨数次数(次)")
    private BigDecimal ccExfiAct;

    @ApiModelProperty(value = "质量合格率(%)")
    private BigDecimal qrExEpdmAct;

    @Excel(name = "QR_ex_epdm_act(%)", column = "G")
    @ApiModelProperty(value = "质量合格率(%)")
    private String qrExEpdmActStr;

    @Excel(name = "HR_ET_dir_act_quantity(人)", column = "H")
    @ApiModelProperty(value = "直接员工离职人数(人)")
    private BigDecimal hrEtDirAct;

    @Excel(name = "HR_ET_ind_act_quantity(人)", column = "I")
    @ApiModelProperty(value = "间接员工离职人数(人)")
    private BigDecimal hrEtIndAct;

    @Excel(name = "HR_SAH_dir_act_hour（h）", column = "J")
    @ApiModelProperty(value = "直接员工缺勤小时（h）")
    private BigDecimal hrSahDirAct;

    @Excel(name = "HR_SAH_ind_act_hour（h）", column = "K")
    @ApiModelProperty(value = "间接员工缺勤小时（h）")
    private BigDecimal hrSahIndAct;

    @ApiModelProperty(value = "赢单率(%)")
    private BigDecimal winRate;

    @Excel(name = "Win rate(%)", column = "L")
    @ApiModelProperty(value = "赢单率(%)")
    private String winRateStr;


    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();
}
