package com.artfess.cqlt.utils;

import com.alibaba.fastjson.JSON;
import com.artfess.base.enums.FaTargetTypeEnum;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.vo.DateReqVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpQueryReqVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.cqlt.vo.QueryReqVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 财务大屏相关工具类
 *
 * @Author : min.wu
 * @Date: 2023/05/11 15:17
 */
public class FinancialTimeUtils {

    /**
     * 处理时间入参
     *
     * @param t
     * @param type
     */
    public DateReqVo processDateReqVo(ReportReqVo t, String type) {

        AtomicReference<DateReqVo> dateReqVo = new AtomicReference<>(new DateReqVo());
        List<QueryReqVo> queryList = t.getQueryList();
        if (CollectionUtils.isEmpty(queryList)) {
            return createDateReqVo(type, dateReqVo.get());
        }
        Map<String, QueryReqVo> queryMap = queryList.stream().collect(Collectors.toMap(item -> item.getType(), item -> item));
        if (!queryMap.containsKey(type)) {
            return createDateReqVo(type, dateReqVo.get());
        }
        queryMap.forEach((k, v) -> {
            if (!k.equals(type)) {
                return;
            }
            QueryReqVo queryReqVo = queryMap.get(type);
            if (null != queryReqVo && null != queryReqVo.getDateReqVo()) {
                dateReqVo.set(queryReqVo.getDateReqVo());
            }
            createDateReqVo(type, dateReqVo.get());
        });
        return dateReqVo.get();
    }

    public DateReqVo createDateReqVo(String type, DateReqVo t) {
        if ("1".equals(type) || "2".equals(type) || "9".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year - 1);
            }

            if (null == t.getStartMonth() || null == t.getEndMonth()) {
                t.setEndMonth(12);
                t.setStartMonth(1);
            }
        } else if ("3".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            int monthValue = LocalDate.now().getMonthValue();
            t.setStartMonth(1);
            if (1 == monthValue) {
                t.setEndMonth(1);
            } else {
                t.setEndMonth(monthValue - 1);
            }
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 1);

        } else if ("4".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }
            if (null == t.getStartMonth()) {
                t.setStartMonth(1);
            } else {
                t.setStartMonth(t.getStartMonth() - 1);
            }

            if (null == t.getEndMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setEndMonth(12);
                } else {
                    t.setEndMonth(monthValue - 1);
                }
            }

        } else if ("5".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }

            if (null == t.getStartYear() || null == t.getEndYear()) {
                t.setEndYear(t.getYear());
                t.setStartYear(t.getYear() - 5);
            }
        } else if ("6".equals(type) || "7".equals(type) || "10".equals(type) || "11".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }

            if (null == t.getStartMonth()) {
                t.setStartMonth(1);
            }

            if (null == t.getEndMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setEndMonth(12);
                } else {
                    t.setEndMonth(monthValue - 1);
                }
            }

        } else if ("12".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }

            if (null == t.getMonth()) {
                int monthValue = LocalDate.now().getMonthValue();
                if (monthValue == 1) {
                    t.setYear(t.getYear() - 1);
                    t.setMonth(12);
                } else {
                    t.setMonth(LocalDate.now().getMonthValue() - 1);
                }
            }
        } else if ("15".equals(type)) {
            if (null == t.getYear()) {
                int year = LocalDate.now().getYear();
                t.setYear(year);
            }

            if (null == t.getStartQuarter()) {
                t.setStartQuarter(1);
            }

            if (null == t.getEndQuarter()) {
                t.setEndQuarter(4);
            }
        }

        return t;
    }

    /**
     * 指标信息转换
     *
     * @param target
     * @param type
     * @param faReportRespVos
     * @return
     */
    public FaTargetRespVo getFaTargetRespVo(SysSubjectTarget target, String type, List<FaReportRespVo> faReportRespVos) {
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(target.getName());
        resultFa.setTargetNameEn(target.getTargetNameEn());
        resultFa.setType(type);
        resultFa.setLevel(target.getTargetLevel());
        resultFa.setSn(target.getSn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setContainType(target.getType());
        if ("1".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("10K€");
        }

        if ("万欧".equals(target.getUnit())) {
            resultFa.setTargetUnit("10K€");
        }

        if ("2".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("亿欧");
        }
        if ("万欧/人".equals(target.getUnit())) {
            resultFa.setStaLat("3");
            resultFa.setTargetUnit("10K€/person");
        }
        if ("人".equals(target.getUnit())) {
            resultFa.setTargetUnit("person");
        }
        if (!StringUtils.isEmpty(target.getUnit())) {
            faReportRespVos.forEach(reportRespVo -> {
                conversionUnit(reportRespVo, target);
                // 人资相关指标没有预算值
                if (target.getUnit().contains("人")) {
                    reportRespVo.setBudget(null);
                }
                if (StringUtils.isEmpty(target.getStaLat())) {
                    return;
                }
                if (target.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    if(!"%".equals(target.getUnit())){
                        String differenceRate = null;
                        if (0 != reportRespVo.getBudget().doubleValue()) {
                            differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100")) + "%";
                        }
                        reportRespVo.setDifferenceRate(differenceRate);
                    }

                }
            });
        }

        return resultFa;
    }

    public void conversionUnit(FaReportRespVo reportRespVo, SysSubjectTarget target) {
        if (StringUtils.isEmpty(target.getConversionUnit())) {
            return;
        }
        if (!target.getUnit().contains("欧")) {
            return;
        }
        BigDecimal actual = BigDecimal.ZERO;
        BigDecimal budget = BigDecimal.ZERO;
        if ("1".equals(target.getConversionUnit())) {
            if (null != reportRespVo.getActual()) {
                actual = reportRespVo.getActual().divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP);
            }
            if (null != reportRespVo.getBudget()) {
                budget = reportRespVo.getBudget().divide(new BigDecimal(10000), 2, BigDecimal.ROUND_HALF_UP);
            }
        }

        if ("2".equals(target.getConversionUnit())) {
            if (null != reportRespVo.getActual()) {
                actual = reportRespVo.getActual().divide(new BigDecimal(100000000), 2, BigDecimal.ROUND_HALF_UP);
            }
            if (null != reportRespVo.getBudget()) {
                budget = reportRespVo.getBudget().divide(new BigDecimal(100000000), 2, BigDecimal.ROUND_HALF_UP);
            }
        }

        reportRespVo.setActual(actual);
        // 人资相关指标没有预算值
        if ("万欧/人".equals(target.getUnit())) {
            reportRespVo.setBudget(null);
        } else {
            reportRespVo.setBudget(budget);
        }

    }

    public void processDateQuery(ReportReqVo t, DateReqVo dateReqVo) {
        t.setStartYear(dateReqVo.getStartYear());
        t.setEndYear(dateReqVo.getEndYear());
        t.setYear(dateReqVo.getYear());
        t.setMonth(dateReqVo.getMonth());
        t.setStartMonth(dateReqVo.getStartMonth());
        t.setEndMonth(dateReqVo.getEndMonth());
        t.setQuarter(dateReqVo.getQuarter());
        t.setStartQuarter(dateReqVo.getStartQuarter());
        t.setEndQuarter(dateReqVo.getEndQuarter());
    }

    public FaTargetRespVo getCurrentFaTargetRespVo(FaTargetTypeEnum targetTypeEnum, SysSubjectTarget target, String type, List<FaReportRespVo> faReportRespVos) {
        FaTargetRespVo resultFa = new FaTargetRespVo();
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetId(target.getId());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        resultFa.setType(type);
        resultFa.setLevel(target.getTargetLevel());
        resultFa.setSn(target.getSn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setLinksType(target.getLinksType());
        resultFa.setContainType(target.getType());
        if ("万欧/人".equals(target.getUnit())) {
            resultFa.setStaLat("3");
            resultFa.setTargetUnit("10K€/person");
        }
        if ("万欧".equals(target.getUnit())) {
            resultFa.setTargetUnit("10K€");
        }
        if ("1".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("10K€");
        }

        if ("2".equals(target.getConversionUnit())) {
            resultFa.setTargetUnit("亿欧");
        }
        if ("人".equals(target.getUnit())) {
            resultFa.setTargetUnit("person");
        }

        if (!StringUtils.isEmpty(target.getUnit()) && !CollectionUtils.isEmpty(faReportRespVos)) {
            faReportRespVos.forEach(reportRespVo -> {
                conversionUnit(reportRespVo, target);
                if (target.getUnit().contains("人")) {
                    reportRespVo.setBudget(null);
                }
                if (StringUtils.isEmpty(resultFa.getStaLat())) {
                    return;
                }
                if (resultFa.getStaLat().length() < 2) {
                    return;
                }
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    if(!"%".equals(target.getUnit())){
                        String differenceRate = null;
                        if (0 != reportRespVo.getBudget().doubleValue()) {
                            differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, BigDecimal.ROUND_HALF_UP).multiply(new BigDecimal("100")) + "%";
                        }
                        reportRespVo.setDifferenceRate(differenceRate);
                    }
                }
            });

        }

        return resultFa;
    }

    /**
     * 处理时间入参
     *
     * @param t
     * @param type
     */
    public OpDateReqVo processOpDateReqVo(OpReportReqVo t, String type) {

        AtomicReference<OpDateReqVo> dateReqVo = new AtomicReference<>(new OpDateReqVo());
        List<OpQueryReqVo> queryList = t.getQueryList();
        if (CollectionUtils.isEmpty(queryList)) {
            return createOpDateReqVo(type, dateReqVo.get());
        }
        Map<String, OpQueryReqVo> queryMap = queryList.stream().collect(Collectors.toMap(item -> item.getType(), item -> item));
        if (!queryMap.containsKey(type)) {
            return createOpDateReqVo(type, dateReqVo.get());
        }
        queryMap.forEach((k, v) -> {
            if (!k.equals(type)) {
                return;
            }
            OpQueryReqVo queryReqVo = queryMap.get(type);
            if (null != queryReqVo && null != queryReqVo.getDateReqVo()) {
                dateReqVo.set(queryReqVo.getDateReqVo());
            }
            createOpDateReqVo(type, dateReqVo.get());
        });
        return dateReqVo.get();
    }

    public OpDateReqVo createOpDateReqVo(String type, OpDateReqVo t) {

        return t;
    }

    /**
     * 处理运营大屏时间参数
     *
     * @param t
     * @param dateReqVo
     */
    public void processOpDateQuery(OpReportReqVo t, OpDateReqVo dateReqVo) {
        t.setStartYear(dateReqVo.getStartYear());
        t.setEndYear(dateReqVo.getEndYear());
        t.setYear(dateReqVo.getYear());
        t.setMonth(dateReqVo.getMonth());
        t.setStartMonth(dateReqVo.getStartMonth());
        t.setEndMonth(dateReqVo.getEndMonth());
        t.setCustomer(dateReqVo.getCustomer());
        t.setProduct(dateReqVo.getProduct());
        t.setSubjectCode(dateReqVo.getSubjectCode());
    }
}
