package com.artfess.cqlt.task.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.task.model.SchedulerTask;
import org.quartz.SchedulerException;

/**
 * 数据抽取任务信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2021-12-16
 */
public interface SchedulerTaskManager extends BaseManager<SchedulerTask> {

    /**
     * 分页查询
     * @param queryFilter
     * @Return: com.artfess.base.query.PageList<com.artfess.cssc.model.model.ModelTask>
     * @Author: chens
     * @Date: 2021/12/20 14:30
     */
    PageList<SchedulerTask> sliceQuerySchedulerTask(QueryFilter<SchedulerTask> queryFilter);

    /**
     * 添加数据抽取任务
     * @param schedulerTask
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:11
     */
    boolean insertSchedulerTask(SchedulerTask schedulerTask);

    /**
     * 修改数据抽取任务
     * @param schedulerTask
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:12
     */
    boolean updateSchedulerTask(SchedulerTask schedulerTask) throws SchedulerException;

    /**
     * 根据ID删除数据抽取任务
     * @param id
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/12/16 19:12
     */
    boolean deleteSchedulerTaskById(String id) throws SchedulerException;


    /**
     * @Description: 启动数据抽取任务
     * @param taskId  任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean startUpJob(String taskId) throws SchedulerException;

    /**
     * @Description: 停止数据抽取任务
     * @param taskId  任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean stopJob(String taskId) throws SchedulerException;

    /**
     * @Description: 删除数据抽取任务
     * @param taskId  任务ID
     * @Return: boolean
     * @Author: chens
     * @Date: 2021/11/12 16:43
     */
    boolean delJob(String taskId) throws SchedulerException;


}
