package com.artfess.cqlt.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 报表填报科目
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@ApiModel(value="QfReportSubject对象", description="报表填报科目")
public class QfReportSubject extends BaseModel<QfReportSubject> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "报表id")
    @TableField("report_id_")
    @NotNull(message = "QfReportSubject.reportId", groups = {AddGroup.class})
    private String reportId;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    @NotNull(message = "QfReportSubject.subjectCode", groups = {AddGroup.class})
    private String subjectCode;

    @ApiModelProperty(value = "科目名称")
    @TableField("subject_name_")
    @NotNull(message = "QfReportSubject.subjectName", groups = {AddGroup.class})
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getReportId() {
        return reportId;
    }

    public void setReportId(String reportId) {
        this.reportId = reportId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectNameEn() {
        return subjectNameEn;
    }

    public void setSubjectNameEn(String subjectNameEn) {
        this.subjectNameEn = subjectNameEn;
    }

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QfReportSubject{" +
            "id=" + id +
            ", reportId=" + reportId +
            ", subjectCode=" + subjectCode +
            ", subjectName=" + subjectName +
            ", subjectNameEn=" + subjectNameEn +
            ", sn=" + sn +
        "}";
    }
}
