package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--新订单数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfOperationNewOrdersD对象", description="运营--新订单数据填报详情表")
public class QfOperationNewOrdersD extends BaseModel<QfOperationNewOrdersD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "销售报告", column = "A")
    @ApiModelProperty(value = "销售报告")
    @TableField("sales_report_")
    private String salesReport;

    @Excel(name = "客户（英文）", column = "B")
    @ApiModelProperty(value = "客户（英文）")
    @TableField("customer_en_")
    private String customerEn;

    @Excel(name = "客户（中文）", column = "C")
    @ApiModelProperty(value = "客户（中文）")
    @TableField("customer_cn_")
    private String customerCn;

    @Excel(name = "品牌", column = "D")
    @ApiModelProperty(value = "品牌")
    @TableField("model_name_")
    private String modelName;

    @Excel(name = "项目", column = "E")
    @ApiModelProperty(value = "项目")
    @TableField("project_name_")
    private String projectName;

    @Excel(name = "提名时间", column = "F")
    @ApiModelProperty(value = "提名时间")
    @TableField("nomination_date_")
    private String nominationDate;


    @Excel(name = "量产时间", column = "G")
    @ApiModelProperty(value = "量产时间")
    @TableField("production_time_")
    private String productiontime;

    @Excel(name = "年销售额(百万欧）", column = "H")
    @ApiModelProperty(value = "年销售额(百万欧）")
    @TableField("revenue_")
    private BigDecimal revenue;


    @Excel(name = "Revenue lifetime", column = "I")
    @ApiModelProperty(value = "生命周期销售额（百万欧）")
    @TableField("revenue_lifetime_")
    private BigDecimal revenueLifetime;

    @Excel(name = "Enterprise code", column = "J")
    @ApiModelProperty(value = "承接工厂")
    @TableField("enterprise_code_")
    private String enterpriseCode;


    @Excel(name = "Ebitda rate（%）", column = "K")
    @ApiModelProperty(value = "EBITDA利润率（%）")
    @TableField("ebitda_rate_")
    private BigDecimal ebitdaRate;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "填报季度")
    @TableField(exist = false)
    private Integer fillQuarter;

}
