package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--KPI数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-14
 */
@Data
@ApiModel(value="QfOperationKpiD对象", description="运营--KPI数据填报详情表")
public class QfOperationKpiD extends BaseModel<QfOperationKpiD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Company", column = "A")
    @ApiModelProperty(value = "子企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @Excel(name = "事故数（件）", column = "B")
    @ApiModelProperty(value = "事故件数")
    @TableField("hr_acr_act_quantity_")
    private BigDecimal hrAcrActQuantity;

    @Excel(name = "转换率(%)", column = "C")
    @ApiModelProperty(value = "转换率(%)")
    @TableField("tr_exfi_act_")
    private BigDecimal trExfiAct;

    @Excel(name = "设备利用率(%)", column = "D")
    @ApiModelProperty(value = "设备利用率(%)")
    @TableField("oee24_ex_epdm_act_")
    private BigDecimal oee24ExEpdmAct;

    @Excel(name = "客户拒收PPM(件)", column = "E")
    @ApiModelProperty(value = "客户拒收PPM(件)")
    @TableField("crj_exfi_act_")
    private BigDecimal crjExfiAct;

    @Excel(name = "客户抱怨CPM(次)", column = "F")
    @ApiModelProperty(value = "客户抱怨CPM(次)")
    @TableField("cc_exfi_act_")
    private BigDecimal ccExfiAct;

    @Excel(name = "非计划停机率(%)", column = "G")
    @ApiModelProperty(value = "非计划停机率(%)")
    @TableField("qr_ex_epdm_act_")
    private BigDecimal qrExEpdmAct;

    @Excel(name = "员工效率(%)", column = "H")
    @ApiModelProperty(value = "员工效率(%)")
    @TableField("hr_et_dir_act_")
    private BigDecimal hrEtDirAct;


    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "填报季度")
    @TableField(exist = false)
    private Integer fillQuarter;


}
