package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 运营-大屏统计宽表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@ApiModel(value="QfOperatingStatistical对象", description="运营-大屏统计宽表")
public class QfOperatingStatistical extends BaseModel<QfOperatingStatistical> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "英文指标")
    @TableField("target_name_en_")
    private String targetNameEn;

    @ApiModelProperty(value = "指标名称")
    @TableField("target_name_")
    private String targetName;

    @ApiModelProperty(value = "指标单位")
    @TableField("target_unit_")
    private String targetUnit;

    @ApiModelProperty(value = "报表类型(1:年度横比，2:年度趋势，3:季度趋势，4:月度趋势，5:企业对比，6:数值)")
    @TableField("type_")
    private Integer type;

    @ApiModelProperty(value = "指标_ID")
    @TableField("target_id_")
    private String targetId;

    @ApiModelProperty(value = "年份")
    @TableField("year_")
    private Integer year;

    @ApiModelProperty(value = "周数")
    @TableField("week_")
    private Integer week;

    @ApiModelProperty(value = "企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    @TableField("enterprise_area_")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    @TableField("enterprise_type_")
    private Integer enterpriseType;

    @ApiModelProperty(value = "当月实际值")
    @TableField("actual_")
    private BigDecimal actual;

    @ApiModelProperty(value = "当月预算值")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "当年累计实际")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @ApiModelProperty(value = "当年累计预算值")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @ApiModelProperty(value = "实际占收入比例（%）")
    @TableField("actual_rate_")
    private BigDecimal actualRate;

    @ApiModelProperty(value = "预算占收入比例（%）")
    @TableField("budget_rate_")
    private BigDecimal budgetRate;

    @ApiModelProperty(value = "每年预算产量（辆）")
    @TableField("estimated_volume_")
    private BigDecimal estimatedVolume;

    @ApiModelProperty(value = "年化销售额(百万欧）")
    @TableField("revenue_")
    private BigDecimal revenue;

    @ApiModelProperty(value = "生命周期销售额（百万欧）")
    @TableField("revenue_lifetime_")
    private BigDecimal revenueLifetime;

    @ApiModelProperty(value = "EBITDA率（%）")
    @TableField("ebitda_rate_")
    private BigDecimal ebitdaRate;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTargetNameEn() {
        return targetNameEn;
    }

    public void setTargetNameEn(String targetNameEn) {
        this.targetNameEn = targetNameEn;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getTargetUnit() {
        return targetUnit;
    }

    public void setTargetUnit(String targetUnit) {
        this.targetUnit = targetUnit;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTargetId() {
        return targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public Integer getYear() {
        return year;
    }

    public void setYear(Integer year) {
        this.year = year;
    }

    public Integer getWeek() {
        return week;
    }

    public void setWeek(Integer week) {
        this.week = week;
    }

    public String getEnterpriseCode() {
        return enterpriseCode;
    }

    public void setEnterpriseCode(String enterpriseCode) {
        this.enterpriseCode = enterpriseCode;
    }

    public Integer getEnterpriseArea() {
        return enterpriseArea;
    }

    public void setEnterpriseArea(Integer enterpriseArea) {
        this.enterpriseArea = enterpriseArea;
    }

    public Integer getEnterpriseType() {
        return enterpriseType;
    }

    public void setEnterpriseType(Integer enterpriseType) {
        this.enterpriseType = enterpriseType;
    }

    public BigDecimal getActual() {
        return actual;
    }

    public void setActual(BigDecimal actual) {
        this.actual = actual;
    }

    public BigDecimal getBudget() {
        return budget;
    }

    public void setBudget(BigDecimal budget) {
        this.budget = budget;
    }

    public BigDecimal getActualYtd() {
        return actualYtd;
    }

    public void setActualYtd(BigDecimal actualYtd) {
        this.actualYtd = actualYtd;
    }

    public BigDecimal getBudgetYtd() {
        return budgetYtd;
    }

    public void setBudgetYtd(BigDecimal budgetYtd) {
        this.budgetYtd = budgetYtd;
    }

    public BigDecimal getActualRate() {
        return actualRate;
    }

    public void setActualRate(BigDecimal actualRate) {
        this.actualRate = actualRate;
    }

    public BigDecimal getBudgetRate() {
        return budgetRate;
    }

    public void setBudgetRate(BigDecimal budgetRate) {
        this.budgetRate = budgetRate;
    }

    public BigDecimal getEstimatedVolume() {
        return estimatedVolume;
    }

    public void setEstimatedVolume(BigDecimal estimatedVolume) {
        this.estimatedVolume = estimatedVolume;
    }

    public BigDecimal getRevenue() {
        return revenue;
    }

    public void setRevenue(BigDecimal revenue) {
        this.revenue = revenue;
    }

    public BigDecimal getRevenueLifetime() {
        return revenueLifetime;
    }

    public void setRevenueLifetime(BigDecimal revenueLifetime) {
        this.revenueLifetime = revenueLifetime;
    }

    public BigDecimal getEbitdaRate() {
        return ebitdaRate;
    }

    public void setEbitdaRate(BigDecimal ebitdaRate) {
        this.ebitdaRate = ebitdaRate;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QfOperatingStatistical{" +
            "id=" + id +
            ", targetNameEn=" + targetNameEn +
            ", targetName=" + targetName +
            ", targetUnit=" + targetUnit +
            ", type=" + type +
            ", targetId=" + targetId +
            ", year=" + year +
            ", week=" + week +
            ", enterpriseCode=" + enterpriseCode +
            ", enterpriseArea=" + enterpriseArea +
            ", enterpriseType=" + enterpriseType +
            ", actual=" + actual +
            ", budget=" + budget +
            ", actualYtd=" + actualYtd +
            ", budgetYtd=" + budgetYtd +
            ", actualRate=" + actualRate +
            ", budgetRate=" + budgetRate +
            ", estimatedVolume=" + estimatedVolume +
            ", revenue=" + revenue +
            ", revenueLifetime=" + revenueLifetime +
            ", ebitdaRate=" + ebitdaRate +
        "}";
    }
}
