package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 投资--萨固密集团资本性支出年度预算与完成情况填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Data
@ApiModel(value="QfInvestExpenditureD对象", description="投资--萨固密集团资本性支出年度预算与完成情况填报详情表")
public class QfInvestExpenditureD extends BaseModel<QfInvestExpenditureD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Company", column = "A")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "Budget", column = "B")
    @ApiModelProperty(value = "年度资本性支出预算（欧元）")
    @TableField("budget_")
    private BigDecimal budget;

    @Excel(name = "Actual", column = "C")
    @ApiModelProperty(value = "年度资本性支出完成情况（欧元）")
    @TableField("actual_")
    private BigDecimal actual;

    @Excel(name = "Completion Rate", column = "D")
    @ApiModelProperty(value = "完成百分比（%）")
    @TableField("completion_rate_")
    private BigDecimal completionRate;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "差值")
    @TableField(exist = false)
    private BigDecimal differenceValue;

    @ApiModelProperty(value = "差值比率")
    @TableField(exist = false)
    private String differenceRate;

}
