package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 资金--融资租赁填报数据详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Data
@ApiModel(value="QfFinanceLeaseD对象", description="资金--融资租赁填报数据详情表")
public class QfFinanceLeaseD extends BaseModel<QfFinanceLeaseD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "Reference", column = "A")
    @ApiModelProperty(value = "参考（数据的标识）")
    @TableField("reference_")
    private String reference;

    @Excel(name = "enterpriseCode", column = "B")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @Excel(name = "Entity 子公司名称", column = "C")
    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "Counterparty", column = "D")
    @ApiModelProperty(value = "交易对方")
    @TableField("counterparty_")
    private String counterparty;

    @Excel(name = "Ccy", column = "E")
    @ApiModelProperty(value = "币种【字典】（欧元：EUR，人民币：CNY，美元：USD，墨西哥比索：MXN，卢布：RUB，巴西雷亚尔：BRL，印度卢比：INR）")
    @TableField("currency_")
    private String currency;

    @Excel(name = "Initial Value", column = "F")
    @ApiModelProperty(value = "原值（欧元）")
    @TableField("initial_value_")
    private BigDecimal initialValue;

    @Excel(name = "Outstanding", column = "G")
    @ApiModelProperty(value = "未支付金额(欧元）")
    @TableField("qutstanding_")
    private BigDecimal qutstanding;

    @Excel(name = "Start Date", column = "H")
    @ApiModelProperty(value = "起始日")
    @TableField("start_date_")
    private LocalDate startDate;

    @Excel(name = "Deal Type", column = "I")
    @ApiModelProperty(value = "交易类型")
    @TableField("deal_type_")
    private String dealType;

    @Excel(name = "Interest Rate", column = "J")
    @ApiModelProperty(value = "利率%")
    @TableField("interest_rate_")
    private BigDecimal interestRate;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

}
