package com.artfess.cqlt.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 财务-现金流量预算汇总表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@ApiModel(value="QfFinanceCfBudgetS对象", description="财务-现金流量预算汇总表")
public class QfFinanceCfBudgetS extends BaseModel<QfFinanceCfBudgetS> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报年")
    @TableField("fill_year_")
    private Integer fillYear;

    @ApiModelProperty(value = "填报季度")
    @TableField("fill_quarter_")
    private Integer fillQuarter;

    @ApiModelProperty(value = "填报月")
    @TableField("fill_month_")
    private Integer fillMonth;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @ApiModelProperty(value = "当月预算数据汇总值")
    @TableField("budget_total_")
    private BigDecimal budgetTotal;

    @ApiModelProperty(value = "当月预算数据抵扣值")
    @TableField("budget_posting_")
    private BigDecimal budgetPosting;

    @ApiModelProperty(value = "当月预算数据合并值")
    @TableField("budget_consolidated_")
    private BigDecimal budgetConsolidated;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime;

    @ApiModelProperty(value = "排序号")
    @TableField("sn_")
    private Integer sn;

    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMainId() {
        return mainId;
    }

    public void setMainId(String mainId) {
        this.mainId = mainId;
    }

    public Integer getFillYear() {
        return fillYear;
    }

    public void setFillYear(Integer fillYear) {
        this.fillYear = fillYear;
    }

    public Integer getFillQuarter() {
        return fillQuarter;
    }

    public void setFillQuarter(Integer fillQuarter) {
        this.fillQuarter = fillQuarter;
    }

    public Integer getFillMonth() {
        return fillMonth;
    }

    public void setFillMonth(Integer fillMonth) {
        this.fillMonth = fillMonth;
    }

    public LocalDate getFillDate() {
        return fillDate;
    }

    public void setFillDate(LocalDate fillDate) {
        this.fillDate = fillDate;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getSubjectNameEn() {
        return subjectNameEn;
    }

    public void setSubjectNameEn(String subjectNameEn) {
        this.subjectNameEn = subjectNameEn;
    }

    public String getSubjectUnit() {
        return subjectUnit;
    }

    public void setSubjectUnit(String subjectUnit) {
        this.subjectUnit = subjectUnit;
    }

    public BigDecimal getBudgetTotal() {
        return budgetTotal;
    }

    public void setBudgetTotal(BigDecimal budgetTotal) {
        this.budgetTotal = budgetTotal;
    }

    public BigDecimal getBudgetPosting() {
        return budgetPosting;
    }

    public void setBudgetPosting(BigDecimal budgetPosting) {
        this.budgetPosting = budgetPosting;
    }

    public BigDecimal getBudgetConsolidated() {
        return budgetConsolidated;
    }

    public void setBudgetConsolidated(BigDecimal budgetConsolidated) {
        this.budgetConsolidated = budgetConsolidated;
    }

    public LocalDateTime getLastTime() {
        return lastTime;
    }

    public void setLastTime(LocalDateTime lastTime) {
        this.lastTime = lastTime;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "QfFinanceCfBudgetS{" +
            "id=" + id +
            ", mainId=" + mainId +
            ", fillYear=" + fillYear +
            ", fillQuarter=" + fillQuarter +
            ", fillMonth=" + fillMonth +
            ", fillDate=" + fillDate +
            ", subjectCode=" + subjectCode +
            ", subjectName=" + subjectName +
            ", subjectNameEn=" + subjectNameEn +
            ", subjectUnit=" + subjectUnit +
            ", budgetTotal=" + budgetTotal +
            ", budgetPosting=" + budgetPosting +
            ", budgetConsolidated=" + budgetConsolidated +
            ", lastTime=" + lastTime +
        "}";
    }
}
