package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.ProductSalesDataTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSalesProductDDao;
import com.artfess.cqlt.dao.QfOperationSalesProductMDao;
import com.artfess.cqlt.manager.QfOperationSalesProductDManager;
import com.artfess.cqlt.model.QfOperationSalesM;
import com.artfess.cqlt.model.QfOperationSalesProductD;
import com.artfess.cqlt.model.QfOperationSalesProductM;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 运营--产品销售数据填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Service
public class QfOperationSalesProductDManagerImpl extends BaseManagerImpl<QfOperationSalesProductDDao, QfOperationSalesProductD> implements QfOperationSalesProductDManager {

    @Resource
    private QfOperationSalesProductMDao salesProductMDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchSave(QfOperationSalesProductM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setDataType(ProductSalesDataTypeEnum.getType(detail.getDataType()));
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfOperationSalesProductM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfOperationSalesProductM mainInfo = salesProductMDao.selectById(t.getId());
        Assert.notNull(mainInfo, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(mainInfo.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
            detail.setDataType(ProductSalesDataTypeEnum.getType(detail.getDataType()));
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }
}
