package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.OperationTargetTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationNewOrdersDDao;
import com.artfess.cqlt.dao.QfOperationNewOrdersMDao;
import com.artfess.cqlt.manager.QfOperationNewOrdersDManager;
import com.artfess.cqlt.model.QfOperationMacrM;
import com.artfess.cqlt.model.QfOperationNewOrdersD;
import com.artfess.cqlt.model.QfOperationNewOrdersM;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.OpDateReqVo;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpTargetRespVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.artfess.i18n.util.I18nUtil;
import com.google.common.collect.Lists;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;

/**
 * 运营--新订单数据填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-21
 */
@Service
public class QfOperationNewOrdersDManagerImpl extends BaseManagerImpl<QfOperationNewOrdersDDao, QfOperationNewOrdersD> implements QfOperationNewOrdersDManager {

    @Resource
    private QfOperationNewOrdersMDao ordersMDao;

    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchSave(QfOperationNewOrdersM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfOperationNewOrdersM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfOperationNewOrdersM qfOperationNewOrdersM = ordersMDao.selectById(t.getId());
        Assert.notNull(qfOperationNewOrdersM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfOperationNewOrdersM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

    @Override
    public List<OpReportRespVo> yearData(OpReportReqVo t) {
        return this.baseMapper.yearData(t);
    }

    @Override
    public List<OpTargetRespVo> dataAnalysis(OpReportReqVo t, SysSubjectTarget target) {
        List<String> typeList = Arrays.asList(target.getType().split(","));
        List<OpTargetRespVo> resultList = Lists.newArrayList();
        typeList.forEach(type -> {
            OperationTargetTypeEnum targetTypeEnum = OperationTargetTypeEnum.getTarget(type);
            if (null == targetTypeEnum) {
                return;
            }
            OpDateReqVo dateReqVo = financialTimeUtils.processOpDateReqVo(t, type);
            financialTimeUtils.processOpDateQuery(t, dateReqVo);
            switch (targetTypeEnum) {
                case scqysj:
                    t.setYear(null);
                    yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case fscqysj:
                    revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case zzlfx:
                    yearAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case jtwclfx:
                    revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case zqywclfx:
                    yearAreaAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case zbfx:
                    areaRevenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case zqydysj:
                    t.setYear(null);
                    yearEbitdaAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                case ndlbsy:
                    t.setYear(null);
                    revenueLifeAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                default:
                    break;
            }
        });

        return resultList;
    }

    private void yearEbitdaAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = this.baseMapper.yearEbitdaData(t);
        opReportRespVos.forEach(resp -> {
            resp.setActual(resp.getActual().multiply(new BigDecimal(100)));
        });
        resultFa.setTargetUnit("%");
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void areaRevenueLifeAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = this.baseMapper.areaRevenueLifeData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearAreaAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = this.baseMapper.yearAreaData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void revenueLifeAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = this.baseMapper.revenueLifeData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private void yearAnalysis(SysSubjectTarget target, OpReportReqVo t, List<OpTargetRespVo> resultList, OperationTargetTypeEnum targetTypeEnum) {
        OpTargetRespVo resultFa = getOpTargetRespVo(target, targetTypeEnum);
        List<OpReportRespVo> opReportRespVos = this.baseMapper.yearData(t);
        resultFa.setResultData(opReportRespVos);
        resultList.add(resultFa);
    }

    private OpTargetRespVo getOpTargetRespVo(SysSubjectTarget target, OperationTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        OpTargetRespVo resultFa = new OpTargetRespVo();
        resultFa.setTargetId(target.getId());
        resultFa.setTargetName(targetTypeEnum.getTargetName());
        resultFa.setTargetNameEn(targetTypeEnum.getTargetNameEn());
        resultFa.setTargetUnit(target.getUnit());
        resultFa.setType(type);
        resultFa.setSn(targetTypeEnum.getType());
        resultFa.setStaLat(targetTypeEnum.getStaLat());
        return resultFa;
    }
}
