package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestProductivityDDao;
import com.artfess.cqlt.dao.QfInvestProductivityMDao;
import com.artfess.cqlt.manager.QfInvestProductivityDManager;
import com.artfess.cqlt.model.QfInvestProductivityD;
import com.artfess.cqlt.model.QfInvestProductivityM;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 投资--萨固密集团产能分布情况数据填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
@Service
public class QfInvestProductivityDManagerImpl extends BaseManagerImpl<QfInvestProductivityDDao, QfInvestProductivityD> implements QfInvestProductivityDManager {

    @Resource
    private QfInvestProductivityMDao investProductivityMDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfInvestProductivityM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfOperationKpiM.reportId", LocaleContextHolder.getLocale()));
        QfInvestProductivityM qfInvestProductivityM = investProductivityMDao.selectById(t.getId());
        Assert.notNull(qfInvestProductivityM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(qfInvestProductivityM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }

}
