package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfInvestExpenditureDDao;
import com.artfess.cqlt.dao.QfInvestExpenditureMDao;
import com.artfess.cqlt.manager.QfInvestExpenditureDManager;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.cqlt.model.QfInvestExpenditureD;
import com.artfess.cqlt.model.QfInvestExpenditureM;
import com.artfess.i18n.util.I18nUtil;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;

/**
 * 投资--萨固密集团资本性支出年度预算与完成情况填报详情表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 黎沐华
 * @since 2023-02-21
 */
@Service
public class QfInvestExpenditureDManagerImpl extends BaseManagerImpl<QfInvestExpenditureDDao, QfInvestExpenditureD> implements QfInvestExpenditureDManager {


    @Resource
    private QfInvestExpenditureMDao investExpenditureMDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean batchUpdate(QfInvestExpenditureM t) {
        Assert.hasText(t.getId(), I18nUtil.getMessage("QfInvestExpenditureM.reportId", LocaleContextHolder.getLocale()));
        QfInvestExpenditureM investExpenditureD = investExpenditureMDao.selectById(t.getId());
        Assert.notNull(investExpenditureD, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(investExpenditureD.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        t.getList().forEach(detail -> {
            detail.setMainId(t.getId());
        });
        boolean b = this.saveOrUpdateBatch(t.getList());
        return b;
    }
}
