package com.artfess.cqlt.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceSasacCompanyDDao;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyDManager;
import com.artfess.cqlt.manager.QfFinanceSasacCompanyMManager;
import com.artfess.cqlt.manager.QfReportRangeManager;
import com.artfess.cqlt.manager.QfReportSubjectManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinanceSasacCompanyD;
import com.artfess.cqlt.model.QfFinanceSasacCompanyM;
import com.artfess.cqlt.model.QfSubjectInfo;
import com.artfess.poi.util.CustomHeader;
import com.artfess.poi.util.HeaderNode;
import com.google.api.client.util.Lists;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

/**
 * 财务--国资委子企业季度填报详情表 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-03-02
 */
@Service
public class QfFinanceSasacCompanyDManagerImpl extends BaseManagerImpl<QfFinanceSasacCompanyDDao, QfFinanceSasacCompanyD> implements QfFinanceSasacCompanyDManager {

    @Autowired
    private QfReportSubjectManager reportSubjectManager;

    @Autowired
    private QfReportRangeManager reportRangeManager;

    @Autowired
    private QfFinanceSasacCompanyMManager financeSasacCompanyMManager;

    @Override
    public void export(HttpServletRequest request, HttpServletResponse response, List<QfFinanceSasacCompanyD> list, String sheetName) throws IOException {

        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String mainId = list.get(0).getMainId();

        QfFinanceSasacCompanyM mainInfo = financeSasacCompanyMManager.getById(mainId);
        if (null == mainInfo) {
            return;
        }
        String reportId = mainInfo.getReportId();

        List<QfEnterpriseInfo> rangeList = reportRangeManager.getQfEnterpriseInfo(reportId);
        //获取报表关联国内科目信息
        List<QfSubjectInfo> subjectInfoList = reportSubjectManager.getSubjectInfo(reportId);

        Map<String, Integer> rowMap = Maps.newHashMap();
        AtomicReference<Integer> row = new AtomicReference<>(1);
        subjectInfoList.forEach(subject -> {
            row.getAndSet(row.get() + 1);
            rowMap.put(subject.getCode(), row.get());
        });
        Map<String, Integer> columMap = Maps.newHashMap();
        List<HeaderNode> headerNodeList = Lists.newArrayList();
        createHeader(mainInfo, columMap, headerNodeList);
        HeaderNode headerNode;

        Integer headerColum = 7;
        for (QfEnterpriseInfo enterprise : rangeList) {

            String code = enterprise.getCode();
            if("CIGR".equals(code)) {
                continue;
            }
            headerColum++;
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "月本年累计");
            headerNodeList.add(headerNode);
            columMap.put(code + "1", headerColum);

            headerColum++;
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);
            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "月上年同期");
            headerNodeList.add(headerNode);
            columMap.put(code + "2", headerColum);

            headerColum++;
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3) + "月本年累计");
            headerNodeList.add(headerNode);
            columMap.put(code + "3", headerColum);

            headerColum++;
            headerNode = new HeaderNode();
            headerNode.setRow(0);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName(code);
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(1);
            headerNode.setColumn(headerColum);
            headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3) + "月上年同期");
            headerNodeList.add(headerNode);
            columMap.put(code + "4", headerColum);

        }

        for (QfSubjectInfo subject : subjectInfoList) {
            String subjectCode = subject.getCode();
            headerNode = new HeaderNode();
            headerNode.setRow(rowMap.get(subjectCode));
            headerNode.setColumn(columMap.get("subjectName"));
            headerNode.setHeaderName(subject.getName());
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(rowMap.get(subjectCode));
            headerNode.setColumn(columMap.get("subjectCode"));
            headerNode.setHeaderName(subjectCode);
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(rowMap.get(subjectCode));
            headerNode.setColumn(columMap.get("sn"));
            headerNode.setHeaderName(subject.getSn() + "");
            headerNodeList.add(headerNode);

            headerNode = new HeaderNode();
            headerNode.setRow(rowMap.get(subjectCode));
            headerNode.setColumn(columMap.get("unit"));
            if(null != subject.getUnit() ){
                if("￥".equals(subject.getUnit())) {
                    headerNode.setHeaderName("万元");
                } else {
                    headerNode.setHeaderName(subject.getUnit());
                }
            }
            headerNodeList.add(headerNode);

            for (QfFinanceSasacCompanyD companyD : list) {
                if (companyD.getSubjectCode().equals(subject.getCode())) {
                    BigDecimal value = BigDecimal.ONE;
                    if(!StringUtils.isEmpty(companyD.getSubjectUnit()) && "￥".equals(companyD.getSubjectUnit())) {
                        value = new BigDecimal("10000");
                    }

                    if ("CIGR".equals(companyD.getEnterpriseCode())) {
                        if (null != companyD.getFillUnrealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get("fillUnrealData"));
                            headerNode.setHeaderName(companyD.getFillUnrealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }

                        if (null != companyD.getLastYearfillUnrealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get("lastYearfillUnrealData"));
                            headerNode.setHeaderName(companyD.getLastYearfillUnrealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }

                        if (null != companyD.getFillRealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get("fillRealData"));
                            headerNode.setHeaderName(companyD.getFillRealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }
                        if (null != companyD.getLastYearfillRealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get("lastYearfillRealData"));
                            headerNode.setHeaderName(companyD.getLastYearfillRealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }
                    } else {
                        if (null != companyD.getFillUnrealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get(companyD.getEnterpriseCode() + "1"));
                            headerNode.setHeaderName(companyD.getFillUnrealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }

                        if (null != companyD.getLastYearfillUnrealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get(companyD.getEnterpriseCode() + "2"));
                            headerNode.setHeaderName(companyD.getLastYearfillUnrealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }

                        if (null != companyD.getFillRealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get(companyD.getEnterpriseCode() + "3"));
                            headerNode.setHeaderName(companyD.getFillRealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }
                        if (null != companyD.getLastYearfillRealData()) {
                            headerNode = new HeaderNode();
                            headerNode.setRow(rowMap.get(subjectCode));
                            headerNode.setColumn(columMap.get(companyD.getEnterpriseCode() + "4"));
                            headerNode.setHeaderName(companyD.getLastYearfillRealData().divide(value, 2, BigDecimal.ROUND_HALF_UP) + "");
                            headerNodeList.add(headerNode);
                        }
                    }
                }
            }
        }

        String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String fileName = String.format(sheetName + "-%s", date);
        CustomHeader.export(headerNodeList, response, fileName, sheetName);

    }

    private void createHeader(QfFinanceSasacCompanyM mainInfo, Map<String, Integer> columMap, List<HeaderNode> headerNodeList) {
        columMap.put("subjectName", 0);
        HeaderNode headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(0);
        headerNode.setHeaderName("项目");
        headerNodeList.add(headerNode);

        columMap.put("subjectCode", 1);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(1);
        headerNode.setHeaderName("编码");
        headerNodeList.add(headerNode);

        columMap.put("sn", 2);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(2);
        headerNode.setHeaderName("行次");
        headerNodeList.add(headerNode);

        columMap.put("unit", 3);
        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(3);
        headerNode.setHeaderName("单位");
        headerNodeList.add(headerNode);

        columMap.put("fillUnrealData", 4);
        columMap.put("lastYearfillUnrealData", 5);
        columMap.put("fillRealData", 6);
        columMap.put("lastYearfillRealData", 7);

        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(4);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "月本年累计");
        headerNodeList.add(headerNode);


        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(5);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3 - 1) + "月上年同期");
        headerNodeList.add(headerNode);


        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(6);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3) + "月本年累计");
        headerNodeList.add(headerNode);

        headerNode = new HeaderNode();
        headerNode.setRow(1);
        headerNode.setColumn(7);
        headerNode.setHeaderName("1-" + (mainInfo.getFillQuarter() * 3) + "月上年同期");
        headerNodeList.add(headerNode);
    }
}
