package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfFinanceLeaseMDao;
import com.artfess.cqlt.manager.QfFinanceLeaseDManager;
import com.artfess.cqlt.manager.QfFinanceLeaseMManager;
import com.artfess.cqlt.model.QfFinanceLeaseD;
import com.artfess.cqlt.model.QfFinanceLeaseM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 资金-融资租赁填报主表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
@Service
public class QfFinanceLeaseMManagerImpl extends BaseManagerImpl<QfFinanceLeaseMDao, QfFinanceLeaseM> implements QfFinanceLeaseMManager {

    @Autowired
    private QfFinanceLeaseDManager financeLeaseDManager;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfFinanceLeaseD> list, String mainId) {
        QfFinanceLeaseM financeLeaseM = this.baseMapper.selectById(mainId);
        Assert.notNull(financeLeaseM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(financeLeaseM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfFinanceLeaseD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        financeLeaseDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setFillDate(financeLeaseM.getFillDate());
            detail.setMainId(mainId);
        });
        boolean b = financeLeaseDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfFinanceLeaseM t) {
        QfFinanceLeaseM financeLeaseM = baseMapper.selectById(t.getId());
        if(null == financeLeaseM) {
            return false;
        }
        financeLeaseM.setStatus(financeLeaseM.getStatus() == 0? 1:0 );
        int i = this.baseMapper.updateById(financeLeaseM);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfFinanceLeaseM t) {
        QueryWrapper<QfFinanceLeaseM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfFinanceLeaseM> financeLeaseMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if(insert > 0){
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfFinanceLeaseM t) {
        QueryWrapper<QfFinanceLeaseM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfFinanceLeaseM> financeLeaseMS = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(financeLeaseMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if(insert > 0){
            return true;
        }
        return false;
    }
}
