package com.artfess.cqlt.manager;

import com.alibaba.fastjson.JSONObject;
import com.artfess.base.manager.BaseManager;
import com.artfess.cqlt.model.QfEuroRatesD;
import com.artfess.cqlt.model.QfEuroRatesM;
import com.artfess.cqlt.vo.EuroRatesRespVo;
import com.artfess.cqlt.vo.ReportReqVo;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;

/**
 * 资金--欧元同业拆借利率详情表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-07-17
 */
public interface QfEuroRatesDManager extends BaseManager<QfEuroRatesD> {

    boolean batchUpdate(QfEuroRatesM t);

    List<JSONObject> detailQuery(List<QfEuroRatesD> list);

    List<EuroRatesRespVo> euroRatesAnalysis(ReportReqVo t);

    void export(HttpServletRequest request, HttpServletResponse response, List<QfEuroRatesD> rows, String sheetName) throws IOException;
}
