package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfFinanceBsD;
import com.artfess.cqlt.vo.ReportDataVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 财务-资产负债填报详情表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-02
 */
public interface QfFinanceBsDDao extends BaseMapper<QfFinanceBsD> {

    List<String> getEnterpriseCodeHeader(@Param("mainId") String mainId);

    List<String> getSubjectCodes(@Param("mainId") String mainId);

    List<ReportDataVo> getBsDataList(@Param("subjectCodes") List<String> subjectCodes, @Param("fillYear") Integer fillYear, @Param("endMonth") Integer endMonth);
}
