package com.artfess.cqlt.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 资金大屏统计响应参数vo
 *
 * @Author : min.wu
 * @Date: 2023/03/30 17:58
 */
@Data
@ApiModel(value="财务大屏统计请求参数vo")
public class MoneyReportRespVo {

    @ApiModelProperty(value = "预警值")
    private BigDecimal warnValue;



    @ApiModelProperty(value = "指标id")
    private String targerId;

    @ApiModelProperty(value = "年份")
    private Integer year;

    @ApiModelProperty(value = "季度")
    private Integer quarter;

    @ApiModelProperty(value = "月份")
    private Integer month;

    @ApiModelProperty(value = "周")
    private Integer week;

    @ApiModelProperty(value = "企业编码")
    private String enterpriseCode;

    @ApiModelProperty(value = "洲别【字典】")
    private Integer enterpriseArea;

    @ApiModelProperty(value = "经营类型（1:生产企业，2：研发企业，3：其它服务企业，4：特殊企业）")
    private Integer enterpriseType;

    @ApiModelProperty(value = "担保总额")
    private BigDecimal cqltGuarantee;

    @ApiModelProperty(value = "贷款总额(原币)")
    private BigDecimal srcMoney;

    @ApiModelProperty(value = "原币单位")
    private String unit;

    @ApiModelProperty(value = "贷款总额(欧元)")
    private BigDecimal eurMoney;

    @ApiModelProperty(value = "贷款总额(人名币)")
    private BigDecimal cnyMoney;

    //融资数量
    @ApiModelProperty(value = "融资数量")
    private Integer financingCount;
    //融资金额
    @ApiModelProperty(value = "融资总额（欧元）")
    private BigDecimal financingMoney;

    @ApiModelProperty(value = "未支付总额（欧元）")
    private BigDecimal qutstandingMoney;
}
