package com.artfess.cqlt.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 报表导入日志
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-07-21
 */
@Data
@ApiModel(value="QfReportLog对象", description="报表导入日志")
public class QfReportLog extends BaseModel<QfReportLog> {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "导入报表类型（1:利润实际表 2::利润预算表 3::负债实际表 4:负债实际表 5:现金流量实际表 6:现金流量实际表 7:人资实际表）")
    @TableField("report_type_")
    private String reportType;

    @TableField("report_time_")
    private LocalDateTime reportTime;

    @ApiModelProperty(value = "IP地址")
    @TableField("ip_")
    private String ip;

    @ApiModelProperty(value = "导入状态0：成功 1：失败")
    @TableField("reprot_status_")
    private String reprotStatus;

    @ApiModelProperty(value = "导入报表年份")
    @TableField("err_msg_")
    private String errMsg;

    @ApiModelProperty(value = "请求地址")
    @TableField("report_year_")
    private Integer reportYear;

    @ApiModelProperty(value = "导入报表月份")
    @TableField("report_month_")
    private Integer reportMonth;

    @ApiModelProperty(value = "导入报表用户id")
    @TableField("report_user_id_")
    private String reportUserId;

    @ApiModelProperty(value = "导入报表用户姓名")
    @TableField("report_user_name_")
    private String reportUserName;

}
