package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 运营--产品销售数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
@Data
@ApiModel(value="QfOperationSalesProductD对象", description="运营--产品销售数据填报详情表")
public class QfOperationSalesProductD extends BaseModel<QfOperationSalesProductD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "product", column = "A")
    @ApiModelProperty(value = "产品")
    @TableField("product_")
    private String product;

    @ApiModelProperty(value = "当月实际销售额")
    @TableField("actual_")
    private BigDecimal actual;

    @ApiModelProperty(value = "当月预算销售额")
    @TableField("budget_")
    private BigDecimal budget;

    @ApiModelProperty(value = "当月销售差额")
    @TableField("deviation_")
    private BigDecimal deviation;

    @ApiModelProperty(value = "当月销售偏差率(%)")
    @TableField("deviation_rate_")
    private BigDecimal deviationRate;


    @Excel(name = "ActualYTD", column = "B")
    @ApiModelProperty(value = "当年累计实际销售额")
    @TableField("actual_ytd_")
    private BigDecimal actualYtd;

    @Excel(name = "BudgetYTD", column = "C")
    @ApiModelProperty(value = "当年累计预算销售额")
    @TableField("budget_ytd_")
    private BigDecimal budgetYtd;

    @Excel(name = "DeviationabsYtd", column = "D")
    @ApiModelProperty(value = "当年累计销售差额")
    @TableField("deviation_ytd_")
    private BigDecimal deviationYtd;

    @Excel(name = "DeviationYtd(%)", column = "E")
    @ApiModelProperty(value = "当年销售偏差率(%)")
    @TableField("deviation_rate_ytd_")
    private BigDecimal deviationRateYtd;

    @Excel(name = "dataType", column = "F")
    @TableField("data_type_")
    @ApiModelProperty("产品类型:1:密封条,2:胶料,3:建筑,4:工业,5:非汽车")
    private String dataType;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @TableField(exist = false)
    @ApiModelProperty("数据类型，用于销售板块指标数据，见KpiTargetTypeEnum中targetId")
    private String type;

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "填报季度")
    @TableField(exist = false)
    private Integer fillQuarter;

    @ApiModelProperty(value = "企业编码")
    @TableField(exist = false)
    private String enterpriseCode;


    @ApiModelProperty(value = "总人数，用于人均销售统计")
    @TableField(exist = false)
    private BigDecimal pNum;

    @ApiModelProperty(value = "销售总额，用于人均销售统计")
    @TableField(exist = false)
    private BigDecimal income;

}
