package com.artfess.cqlt.model;

import com.artfess.base.annotation.Excel;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 投资--萨固密集团专利授权数据填报详情表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-23
 */
@Data
@ApiModel(value="QfInvestPatentD对象", description="投资--萨固密集团专利授权数据填报详情表")
public class QfInvestPatentD extends BaseModel<QfInvestPatentD> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "主表ID")
    @TableField("main_id_")
    private String mainId;

    @ApiModelProperty(value = "填报日期")
    @TableField("fill_date_")
    private LocalDate fillDate;

    @Excel(name = "enterpriseCode", column = "A")
    @ApiModelProperty(value = "所属企业编码")
    @TableField("enterprise_code_")
    private String enterpriseCode;

    @ApiModelProperty(value = "所属企业名称")
    @TableField("enterprise_name_")
    private String enterpriseName;

    @ApiModelProperty(value = "所属企业英文名称")
    @TableField("enterprise_name_en_")
    private String enterpriseNameEn;

    @Excel(name = "subjectCode", column = "B")
    @ApiModelProperty(value = "科目编码")
    @TableField("subject_code_")
    private String subjectCode;

    @ApiModelProperty(value = "科目层级")
    @TableField("subject_level_")
    private Integer subjectLevel;

    @Excel(name = "subjectName", column = "C")
    @ApiModelProperty(value = "科目中文名称")
    @TableField("subject_name_")
    private String subjectName;

    @ApiModelProperty(value = "科目英文名称")
    @TableField("subject_name_en_")
    private String subjectNameEn;

    @ApiModelProperty(value = "科目计量单位位（由科目关联）")
    @TableField("subject_unit_")
    private String subjectUnit;

    @Excel(name = "fillData", column = "D")
    @ApiModelProperty(value = "填报数量")
    @TableField("fill_data_")
    private BigDecimal fillData;

    @ApiModelProperty(value = "最终编辑时间")
    @TableField("last_time_")
    private LocalDateTime lastTime = LocalDateTime.now();

    @ApiModelProperty(value = "填报年")
    @TableField(exist = false)
    private Integer fillYear;

    @ApiModelProperty(value = "填报月")
    @TableField(exist = false)
    private Integer fillMonth;

    @ApiModelProperty(value = "集合数据")
    @TableField(exist = false)
    private List<QfInvestPatentD> list;

    public QfInvestPatentD() {
    }

    public QfInvestPatentD(BigDecimal fillData, Integer fillYear) {
        this.fillData = fillData;
        this.fillYear = fillYear;
    }


}
